/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.less;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.lesscss.spi.UriResolverStateChangedEvent;
import com.atlassian.plugins.less.PreCompilationUtils;
import com.atlassian.plugins.less.UriResolverManager;
import com.atlassian.plugins.less.UriStateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingUriStateManager
implements UriStateManager {
    private static final Pattern IMPORT_URI_PATTERN = Pattern.compile("@import(?:-once)?\\s+(?:\\(([^)]+)\\)\\s+)?\"([^\"]+)\";");
    private static final int GROUP_IMPORT_OPTIONS = 1;
    private static final int GROUP_IMPORT_URI = 2;
    private static final Logger log = LoggerFactory.getLogger(CachingUriStateManager.class);
    private final LoadingCache<URI, UriInfo> cache;
    private final EventPublisher eventPublisher;
    private final UriResolverManager uriResolverManager;

    public CachingUriStateManager(EventPublisher eventPublisher, UriResolverManager uriResolverManager) {
        this.eventPublisher = eventPublisher;
        this.uriResolverManager = uriResolverManager;
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<URI, UriInfo>(){

            public UriInfo load(URI uri) throws Exception {
                return CachingUriStateManager.this.computeUriInfo(uri);
            }
        });
    }

    public void registerEventListeners() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void unRegisterEventListeners() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public String getState(URI uri) {
        ArrayList states = Lists.newArrayList();
        this.collectUriState(Sets.newHashSet((Object[])new URI[]{uri}), states, uri, true);
        return Joiner.on((char)',').join((Iterable)states);
    }

    @EventListener
    public void onStateChanged(UriResolverStateChangedEvent event) {
        Iterator it = this.cache.asMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!event.hasChanged((URI)entry.getKey())) continue;
            log.debug("LESS has changed. Expiring lastModified cache. uri={}", entry.getKey());
            it.remove();
        }
    }

    @VisibleForTesting
    void collectUris(Set<URI> collector, URI baseUri, String chunk) {
        Matcher matcher = IMPORT_URI_PATTERN.matcher(chunk);
        while (matcher.find()) {
            ImportOption importOption = ImportOption.fromString(matcher.group(1));
            String path = matcher.group(2);
            if (path == null) continue;
            URI uri = baseUri.resolve(path = importOption.amendURI(path));
            if (this.isUriSupported(uri)) {
                collector.add(uri);
                continue;
            }
            log.warn("Ignoring LESS uri as it is not supported. uri={}", (Object)uri);
        }
    }

    private void collectUriState(Set<URI> alreadySeen, List<String> states, URI uri, boolean root) {
        UriInfo value = (UriInfo)this.cache.getUnchecked((Object)uri);
        if (root && value.preCompiledState != null) {
            states.add(value.preCompiledState);
            return;
        }
        states.add(value.state);
        for (URI dependency : value.dependencies) {
            if (!alreadySeen.add(dependency)) continue;
            this.collectUriState(alreadySeen, states, dependency, false);
        }
    }

    private UriInfo computeUriInfo(URI uri) {
        log.debug("Computing LESS uri info. uri={}", (Object)uri);
        UriResolver uriResolver = this.getResolverOrThrow(uri);
        URI preCompiledUri = PreCompilationUtils.resolvePreCompiledUri(uriResolver, uri);
        Set<URI> dependencies = this.getDependencies(uri);
        return new UriInfo(dependencies, preCompiledUri == null ? null : uriResolver.encodeState(preCompiledUri), uriResolver.encodeState(uri));
    }

    private Set<URI> getDependencies(final URI baseUri) {
        final LinkedHashSet collector = Sets.newLinkedHashSet();
        try (InputStreamReader reader = new InputStreamReader(this.getResolverOrThrow(baseUri).open(baseUri));){
            Iterables.filter((Iterable)CharStreams.readLines((Readable)reader), (Predicate)new Predicate<String>(){

                public boolean apply(String line) {
                    CachingUriStateManager.this.collectUris(collector, baseUri, line);
                    return true;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return Collections.unmodifiableSet(collector);
    }

    private UriResolver getResolverOrThrow(URI uri) {
        UriResolver uriResolver = this.getResolver(uri);
        if (uriResolver == null) {
            throw new IllegalArgumentException("Unsupported URI " + uri.toASCIIString());
        }
        return uriResolver;
    }

    private UriResolver getResolver(URI uri) {
        for (UriResolver uriResolver : this.uriResolverManager.getResolvers()) {
            if (!uriResolver.supports(uri)) continue;
            return uriResolver;
        }
        return null;
    }

    private boolean isUriSupported(URI uri) {
        return this.getResolver(uri) != null;
    }

    private static class UriInfo {
        private final Set<URI> dependencies;
        private final String preCompiledState;
        private final String state;

        private UriInfo(Set<URI> dependencies, String preCompiledState, String state) {
            this.dependencies = dependencies;
            this.preCompiledState = preCompiledState;
            this.state = state;
        }
    }

    private static enum ImportOption {
        CSS,
        INLINE{

            @Override
            String amendURI(String uri) {
                if (!uri.endsWith(".css")) {
                    uri = uri + ".css";
                }
                return uri;
            }
        }
        ,
        LESS,
        NONE{

            @Override
            String amendURI(String uri) {
                if (!uri.endsWith(".less")) {
                    uri = uri + ".less";
                }
                return uri;
            }
        };


        String amendURI(String uri) {
            return uri;
        }

        private static ImportOption fromString(String value) {
            if (value != null) {
                value = value.toUpperCase(Locale.US);
                for (ImportOption importOption : ImportOption.values()) {
                    if (!importOption.name().equals(value)) continue;
                    return importOption;
                }
            }
            return NONE;
        }
    }
}

