package com.atlassian.plugins.less;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;

public class LessWebResourceTransformerFactory implements WebResourceTransformerFactory {

    private final LessCompilerSupplier lessCompiler;
    private final PluginAccessor pluginAccessor;
    private final UriStateManager uriStateManager;
    private final UriResolverManager uriResolverManager;
    private final EventPublisher eventPublisher;

    public LessWebResourceTransformerFactory(LessCompilerSupplier lessCompiler,
                                             PluginAccessor pluginAccessor,
                                             UriStateManager uriStateManager,
                                             UriResolverManager uriResolverManager,
                                             EventPublisher eventPublisher) {
        this.lessCompiler = lessCompiler;
        this.pluginAccessor = pluginAccessor;
        this.uriStateManager = uriStateManager;
        this.uriResolverManager = uriResolverManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters params) {
        return new LessTransformerUrlBuilder(
                pluginAccessor.getEnabledPluginModule(params.getPluginKey() + ":" + params.getModuleKey()),
                uriStateManager);
    }

    @Override
    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters params) {
        return new LessWebResourceTransformer(lessCompiler, uriResolverManager, params.getPluginKey(), eventPublisher);
    }
}
