package com.atlassian.plugins.less;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlBuilder;

import java.net.URI;

public class LessTransformerUrlBuilder implements TransformerUrlBuilder {

    private final ModuleDescriptor descriptor;
    private final UriStateManager uriStateManager;

    public LessTransformerUrlBuilder(ModuleDescriptor descriptor, UriStateManager uriStateManager) {
        this.descriptor = descriptor;
        this.uriStateManager = uriStateManager;
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder) {
        for (ResourceDescriptor resourceDescriptor : descriptor.getResourceDescriptors()) {
            if (resourceDescriptor.getLocation().endsWith(".less")) {
                URI uri = UriUtils.resolveUri(
                        descriptor.getPluginKey(),
                        resourceDescriptor.getResourceLocationForName(null)
                );
                urlBuilder.addToHash("LESS-URI-STATE", uriStateManager.getState(uri));
            }
        }
    }
}
