/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.jira;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.link.AbstractRemoteIssueLinkEvent;
import com.atlassian.linkaggregation.AbstractRemoteLinkEvent;
import com.atlassian.linkaggregation.RemoteLinkAggregateTimeModifiedService;
import com.atlassian.linkaggregation.jira.webhooks.TemporaryWebhookSolution;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RemoteLinkCacheClearer
implements InitializingBean,
DisposableBean {
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private final TemporaryWebhookSolution temporaryWebhookSolution;

    public RemoteLinkCacheClearer(PluginAccessor pluginAccessor, EventPublisher eventPublisher, TemporaryWebhookSolution temporaryWebhookSolution) {
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
        this.temporaryWebhookSolution = temporaryWebhookSolution;
    }

    @EventListener
    public void clearCacheDueToEvent(AbstractRemoteLinkEvent event) {
        this.clearCacheForGlobalId(event.getGlobalIds());
    }

    @EventListener
    public void clearCacheDueToRemoteIssueEvent(AbstractRemoteIssueLinkEvent event) {
        this.clearCacheForGlobalId(Sets.newHashSet((Object[])new String[]{event.getGlobalId()}));
    }

    private void clearCacheForGlobalId(Set<String> globalIds) {
        List enabledTimeModifiedServices = this.pluginAccessor.getEnabledModulesByClass(RemoteLinkAggregateTimeModifiedService.class);
        Iterable filteredEnabledTimeModifiedServices = Iterables.filter((Iterable)enabledTimeModifiedServices, (Predicate)Predicates.notNull());
        for (String globalId : globalIds) {
            for (RemoteLinkAggregateTimeModifiedService timeModifiedService : filteredEnabledTimeModifiedServices) {
                timeModifiedService.clearCacheForGlobalId(globalId);
            }
            this.temporaryWebhookSolution.sendDeleteToConfluence(globalId);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

