/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.jira;

import com.atlassian.linkaggregation.RemoteLinkAggregateTimeModifiedService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTimeModifiedService
implements RemoteLinkAggregateTimeModifiedService {
    private final Logger log = LoggerFactory.getLogger(JiraTimeModifiedService.class);
    private final Cache<String, DateTime> dateModifiedCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, DateTime>(){

        public DateTime load(String key) throws Exception {
            return DateTime.now();
        }
    });

    public DateTime getLastModified(List<String> globalIds) {
        DateTime lastModified = DateTime.now().minusHours(1);
        for (String globalId : globalIds) {
            DateTime modified = (DateTime)this.dateModifiedCache.getUnchecked((Object)globalId);
            if (!modified.isAfter((ReadableInstant)lastModified)) continue;
            lastModified = modified;
        }
        return lastModified;
    }

    public void clearCacheForGlobalId(String globalId) {
        if (globalId != null) {
            this.log.debug("Clearing remote link aggregator cache for global id {}", (Object)globalId);
            this.dateModifiedCache.invalidate((Object)globalId);
        }
    }

    public void clearCache() {
        this.dateModifiedCache.invalidateAll();
    }
}

