
AJS.test.require("com.atlassian.plugins.jira-project-creation:project-creation-resources");

test("test getFilteredRootTypes", function() {
    var response = {
        types: {
            "jira.project": {},
            "confluence.space": {"key": "AAA"},
            "bamboo": {},
            "something else": {}
        }
    };

    var filteredList = ATLAS_PROJECT_CREATE.getFilteredRootTypes(response);

    ok(typeof filteredList["jira.project"] == "undefined", "Jira project is not in returned list");
    ok(filteredList["confluence.space"].key == "AAA", "Confluence space is present in returned list");
});

test("test creating link", function() {
    var createdThings = {
        "confluence.space": {
            "type": {
                "capabilityKey": "confluence.space",
                "baseUrl": "http://localhost/confluence/rest/capabilities"
            },
            "data": {
                "key": "CS-AAA"
            }
        },
        "bamboo.project": {
            type: {
                "capabilityKey": "bamboo.project",
                "baseUrl": "http://localhost/bamboo/rest/capabilities"
            },
            "data": {
                "key": "BP-AAA"
            }
        },
        "fisheye.repository": {
            type: {
                "capabilityKey": "fisheye.repository",
                "baseUrl": "http://localhost/fecru/rest/capabilities"
            },
            "data": {
                "key": "FE-AAA"
            }
        },
        "crucible.project": {
            type: {
                "capabilityKey": "crucible.project",
                "baseUrl": "http://localhost/fecru/rest/capabilities"
            },
            "data": {
                "key": "CR-AAA"
            }
        }
    };
    var projectKey = "AAA";
    var mockProjectCreationPage = {
        find: function(selector) {
            return {
                html: function(html) {

                }
            };
        }
    };

    var linkRequests = [];
    function strEndswith(str, needle) {
        return str.substring(str.length - needle.length, str.length) === needle;
    }

    var assertLinkExists = function(fromKey, toKey) {
        var foundLink = false;
        for (req in linkRequests) {
            if (linkRequests.hasOwnProperty(req)) {
                if (strEndswith(linkRequests[req].local, "/" + fromKey) && strEndswith(linkRequests[req].target, "/" + toKey)) {
                    foundLink = true;
                }
            }
        }
        ok(foundLink, "found link between " + fromKey + " and " + toKey);
    };

    AJS.$.ajax = function (url, params) {
        linkRequests.push(JSON.parse(params.data));
        try {
            if (typeof params["success"] == "function") {
                params.success();
            }
        } catch (err) {
            console.log(err);
        }

        try {
            if (typeof params["complete"] == "function") {
                params.complete(null, "success");
            }
        } catch (err) {
            console.log(err);
        }
    };

    var dialog = {
        updateHeight: function(){}
    };
    ATLAS_PROJECT_CREATE.linkAllTheThings(dialog, createdThings, projectKey, mockProjectCreationPage);

    //assert that all the correct links were created
    ok(linkRequests.length == 20, "Number of links created from sample entity set: " + linkRequests.length + " (expected 20)");

    //links from JIRA
    assertLinkExists("AAA", "CS-AAA");
    assertLinkExists("AAA", "BP-AAA");
    assertLinkExists("AAA", "FE-AAA");
    assertLinkExists("AAA", "CR-AAA");

    //links from confluence
    assertLinkExists("CS-AAA", "AAA");
    assertLinkExists("CS-AAA", "BP-AAA");
    assertLinkExists("CS-AAA", "FE-AAA");
    assertLinkExists("CS-AAA", "CR-AAA");

    //links from bamboo
    assertLinkExists("BP-AAA", "AAA");
    assertLinkExists("BP-AAA", "CS-AAA");
    assertLinkExists("BP-AAA", "FE-AAA");
    assertLinkExists("BP-AAA", "CR-AAA");

    //links from fisheye
    assertLinkExists("FE-AAA", "AAA");
    assertLinkExists("FE-AAA", "CS-AAA");
    assertLinkExists("FE-AAA", "BP-AAA");
    assertLinkExists("FE-AAA", "CR-AAA");

    //links from crucible
    assertLinkExists("CR-AAA", "AAA");
    assertLinkExists("CR-AAA", "CS-AAA");
    assertLinkExists("CR-AAA", "BP-AAA");
    assertLinkExists("CR-AAA", "FE-AAA");

    expect(21); // 1 assertion for each link that should exist, plus 1 assertion for the number of links
    
});
