(function ($) {
    "use strict";

    AJS.namespace("JIRA.AttachImagesPlugin");

    /**
     * Determine if a keypress event is a "paste" (the keys differ between platform).
     * @param {Event} event
     * @param {string} [platform] If provided, overrides the value of navigator.platform.
     * @returns {boolean}
     */
    JIRA.AttachImagesPlugin.isPasteEvent = function (event, platform) {
        var V_KEY = 86,
            IS_MAC = (platform || navigator.platform).indexOf("Mac") !== -1;

        return event.which === V_KEY && (IS_MAC ? event.metaKey : event.ctrlKey);
    };

    /**
     * Determine if the current browser is supported.
     * @param {string} [platform] If provided, overrides the value of navigator.platform.
     * @returns {boolean}
     */
    JIRA.AttachImagesPlugin.browserIsSupported = function (platform) {
        var classes = document.documentElement.className.split(/\s+/),
            isMac = (platform || navigator.platform).indexOf("Mac") !== -1,
            isSafari = $.inArray("safari", classes) !== -1;

        // Safari isn't supported because it supports neither the HTML5 approach nor the Java applet approach.
        return !(isMac && isSafari);
    };

})(jQuery);
