AJS.test.require("com.atlassian.plugins.jira-html5-attach-images:jira-html5-attach-images-resources", function () {
    "use strict";

    // -----------------------------------------------------------------------------------------------------------------

    // A dirty test is one that doesn't/can't clean up cleanly from itself. Only one dirty test will be run on a page.
    // !!! TO RUN ALL TESTS, CLICK RERUN ON EACH TEST SEPARATELY !!!
    // This is suboptimal, I apologise.
    var dirtyAsyncTest = (function () {
        var pageIsSoiled = false;
        return function (name, func) {
            asyncTest(name, function () {
                if (pageIsSoiled) {
                    expect(0);
                    start();
                    document.getElementById(QUnit.config.current.id).style.opacity = 0.25;
                    return;
                }
                pageIsSoiled = true;
                func.call(this);
            });
        };
    })();

    // -----------------------------------------------------------------------------------------------------------------

    module("JIRA.AttachImagesPlugin.polyfill", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("install API is a function", function () {
        equal(typeof JIRA.AttachImagesPlugin.polyfill.install, "function");
    });

    test("isRequired API returns a boolean", function () {
        ok([true, false].indexOf(JIRA.AttachImagesPlugin.polyfill.isRequired()) != -1)
    });

    test("isRequiredForBinaryAjax API returns a boolean", function () {
        ok([true, false].indexOf(JIRA.AttachImagesPlugin.polyfill.isRequiredForBinaryAjax()) != -1);
    });

    test("proxyAjaxRequest API is a function", function () {
        equal(typeof JIRA.AttachImagesPlugin.polyfill.proxyAjaxRequest, "function");
    });

    _.each({
        "1.7.0_40": "screenshot-legacy.jar",
        "1.7.0_45": "screenshot.jar"
    }, function (archive, version) {
        dirtyAsyncTest(".install() uses " + archive + " for Java " + version, function () {
            var sandbox = this.sandbox;

            JIRA.AttachImagesPlugin.requireDeployJava()
                .done(function (deployJava) {
                    sandbox.stub(deployJava, "runApplet");
                    sandbox.stub(deployJava, "getJREs").returns([version]);

                    JIRA.AttachImagesPlugin.polyfill.install(document)
                        .always(function () {
                            equal(deployJava.runApplet.firstCall.args[0].archive, archive);
                            start();
                        });
                });
        });
    });
});
