/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.conversion.convert.html.word;

import com.aspose.words.Document;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IImageSavingCallback;
import com.aspose.words.SaveOptions;
import com.atlassian.plugins.conversion.AsposeAware;
import com.atlassian.plugins.conversion.convert.html.HtmlConversionData;
import com.atlassian.plugins.conversion.convert.html.word.ImageSavingEventHandler;
import com.atlassian.plugins.conversion.convert.html.word.XHtmlBodyExtractor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.xml.sax.InputSource;

public class WordConverter
extends AsposeAware {
    public static HtmlConversionData convertToHtml(InputStream inputStream, String imagePath) {
        try {
            HtmlConversionData data = new HtmlConversionData();
            Document document = new Document(inputStream);
            document.joinRunsWithSameFormatting();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            HtmlSaveOptions saveOptions = new HtmlSaveOptions(50);
            saveOptions.setEncoding(Charset.forName("utf-8"));
            saveOptions.setImagesFolderAlias(imagePath);
            saveOptions.setExportHeadersFootersMode(0);
            ImageSavingEventHandler imageSavingEventHandler = new ImageSavingEventHandler();
            saveOptions.setImageSavingCallback((IImageSavingCallback)imageSavingEventHandler);
            saveOptions.setExportMetafileAsRaster(true);
            saveOptions.setScaleImageToShapeSize(false);
            saveOptions.setImageResolution(96);
            document.save((OutputStream)output, (SaveOptions)saveOptions);
            for (Map.Entry<String, ByteArrayOutputStream> imageEntry : imageSavingEventHandler.getImageOutputStreams().entrySet()) {
                data.addImage(imageEntry.getKey(), imageEntry.getValue().toByteArray());
            }
            InputSource inputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
            data.setHtml(new XHtmlBodyExtractor().extract(inputSource));
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

