AJS.toInit(function ($) {

    var Routes = {
        removeLink: AJS.contextPath() + '/rest/hipchat/integration/latest/oauth2'
    };

    var pluginKey = "com.atlassian.plugins.base-hipchat-integration-plugin";
    var wrmData = WRM.data instanceof Function ? WRM.data : WRM.data.claim;
    var userLinkContext = wrmData(pluginKey + ":hipchat-user-link-support.user-link-context");
    function getRedirect() {
        var location = window.location;
        var contextPath = AJS.contextPath();
        var path = location.pathname;
        if(path.indexOf(contextPath) === 0) {
            path = path.substr(contextPath.length);
        }
        var query = location.search;
        if(query) {
            query = query.substr(1); // remove leading ?
        }
        return {
            path: path,
            query: query
        };
    }

    function doRedirect(hipchatOauthUri) {
        window.location.assign(hipchatOauthUri);
    }

    function getFragmentFrom(container){

        if(container){
            var redirectHash = container.attr("href");
            if(redirectHash !== undefined &&
                    redirectHash.length > 1 &&
                    redirectHash.indexOf("#") === 0){
                return redirectHash.substr(1); // We remove the hash
            }
        }
        return "";
    }

    var centerSpinner = function() {
        var center = $("<div></div>");
        center.css({
            position: "fixed",
            left: "50%",
            top: "50%"
        });
        $("body").append(center);
        center.spin("large");
    };

    /**
     * Starts the user link process.
     *
     * @param e the event if initiated by an event (optional).
     *          Meant to preventing the default behaviour of the event.
     */
    var startUserLink = function (e) {
        var redirect = getRedirect();
        var postData = {
            url: userLinkContext.beginOauth,
            type: "POST",
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify({
                redirect: redirect.path,
                redirectQuery: redirect.query,
                redirectFragment : e && e.target && getFragmentFrom($(e.target))
            })
        };

        $.ajax(postData)
            .done(doRedirect);

        e && e.preventDefault && e.preventDefault();

        centerSpinner();
    };

    $(document).on('click', '.hipchat-user-link', startUserLink);

    var userUnlink = function (e) {
        var deleteData = {
            url: Routes.removeLink,
            type: 'DELETE',
            contentType: 'application/json'
        };
        $.ajax(deleteData)
            .always(function() {
                window.location.reload();
            });
        e && e.preventDefault && e.preventDefault();

        centerSpinner();
    };

    $(document).delegate('.hipchat-user-unlink', 'click', userUnlink);

    // exports
    window.HipChat = window.HipChat || {};
    window.HipChat.UserLink = window.HipChat.UserLink || {};
    window.HipChat.UserLink.context = userLinkContext;
    window.HipChat.UserLink.linkUser = startUserLink;
    window.HipChat.UserLink.unlinkUser = userUnlink;
});
