/**
 * this script will be used to redirect to the web client
 * or the hipchat client depending on the user preferences.
 * We are going to store this in a cookie to avoid problems if the
 * user changes from computer.
 *
 * hipchat-room-link-url will need api-url, room-id, user-id
 */
(function ($) {

    var HIPCHAT_NATIVE_LINK_ENABLED = "HIPCHAT_NATIVE_LINK_ENABLED";

    function isHipChatNativeLinkEnabled() {
        return AJS.Cookie.read(HIPCHAT_NATIVE_LINK_ENABLED) === "true";
    }

    function getDomainFromUrl(url) {
        var tmp = document.createElement('a');
        tmp.href = url;
        return tmp.hostname;
    }

    function createUrl(baseUrl, path) {
        return baseUrl + (endsWith(baseUrl, "/") ? "" : "/") + path;
    }

    function endsWith(str, suffix) {
        return str.indexOf(suffix, str.length - suffix.length) !== -1;
    }

    function sendAnalyticEvent() {
        var linkType = isHipChatNativeLinkEnabled() ? "inapp" : "web";
        var nativeEnabled = navigator.platform.toUpperCase().indexOf('MAC') >= 0 ? "native.enabled" : "native.disabled";
        var metric  = 'notifications.hipchat.link.clicked.' + linkType  + '.' + nativeEnabled;
        AJS.trigger('analyticsEvent', {name: metric});
    }

    function findTheRightElement(element, tagName) {
        var levels = 2;
        while (levels > 0 && element.prop("tagName").toLowerCase() !== tagName.toLowerCase()) {
            element = element.parent();
            levels--;
        }
        return element;
    }

    $(document).on("click", ".hipchat-room-link-url", function (event) {

        event.preventDefault();

        var target = findTheRightElement($(event.target), "A");
        var url = target.data("api-url");
        var roomId = target.data("room-id");

        if (isHipChatNativeLinkEnabled()) {
            window.location = "hipchat://" + getDomainFromUrl(url) + "/room/" + roomId;
        } else {
            window.open(createUrl(url, "chat/room/" + roomId), "hipchat");
        }

        sendAnalyticEvent();
    });


    $(document).on("click", ".hipchat-user-link-url", function (event) {

        event.preventDefault();

        var target = findTheRightElement($(event.target), "A");
        var url = target.data("api-url");
        var userId = target.data("user-id");

        if (isHipChatNativeLinkEnabled()) {
            window.location = "hipchat://" + getDomainFromUrl(url) + "/user/" + userId;
        } else {
            window.open(createUrl(url, "chat/user/" + userId), "hipchat");
        }

        sendAnalyticEvent();
    });

})(AJS.$);