define('hipchat/invite/enabler', [
    'jquery'
], function (
    $
) {

    var INVITE_VISITED_KEY = "hipchat-invite-visited";
    var enableInviteData = null;
    var discoveryDisabled = false;

    function enableInviteButtonIfFreePlan() {
        if (!enableInviteData) {
            var pluginKey = "com.atlassian.plugins.base-hipchat-integration-plugin";
            var wrmData = WRM.data instanceof Function ? WRM.data : WRM.data.claim;
            enableInviteData = wrmData(pluginKey + ":integration-steps-resources.enable-invite");
        }
        if (!enableInviteData.inviteToHipChatEnabled) {
            return;
        }
        var isInvitationsToGroupAllowedURI = enableInviteData.isInvitationsToGroupAllowedURI;
        $.ajax(isInvitationsToGroupAllowedURI, {
            type: "GET"
        })
            .done(function (isInvitationsToGroupAllowedURI) {
                var inviteButton = $('#hipchat-invite-button');
                inviteButton.click(handleInvitePageVisit);

                if (isInvitationsToGroupAllowedURI && isInvitationsToGroupAllowedURI.free) {
                    inviteButton.removeClass("hidden");
                    conditionallyShowInviteDiscovery(inviteButton);
                } else {
                    $("#hipchat-integration-invite-step-normal-text").hide({
                        complete: function() {
                            $("#hipchat-integration-invite-step-unable-text").show();
                        }
                    });
                }
            });
    }

    function handleInvitePageVisit() {
        try {
            AJS.Cookie.save(INVITE_VISITED_KEY, "true");
        } catch (e) {
            discoveryDisabled = true;
        }
    }

    function hasVistedInvitePage() {
        try {
            var visited = AJS.Cookie.read(INVITE_VISITED_KEY);
            return visited;
        } catch (e) {
            discoveryDisabled = true;
        }
    }

    function conditionallyShowInviteDiscovery(inviteButton) {
        if (AJS.HelpTip && !hasVistedInvitePage() && !discoveryDisabled) {
            var inviteUsersHelpTip = new AJS.HelpTip({
                id: 'hipchat-invite-user-help',
                title: 'Invite users to HipChat',
                bodyHtml: AJS.I18n.getText('plugins.hipchat.admin.invite.help'),
                anchor: inviteButton
            });
            inviteUsersHelpTip.show();
            inviteUsersHelpTip.view.popup.addClass('hipchat-invite-user-help');
        }
    }

    return {
        enableInviteButtonIfFreePlan: enableInviteButtonIfFreePlan
    }
});
