require([
        'hipchat/invite/service'
    ],
    /**
     * Internal ui integration services for invite configuration.
     *
     * @tainted Hipchat.Templates.Configuration (soy template)
     */
    function (inviteService) {
        'use strict';

        AJS.toInit(function ($) {
            var form = $('#hipchat-invite-form');
            var inviteeTemplate = HipChat.Templates.Configuration.invitee;
            var inviteeList = form.find('.hipchat-invitee-list');
            var sendInvitesButton = form.find('.send-invites-button');
            var cancelButton = form.find('.cancel');
            var doneButton = form.find('.done-button');
            var authorizeNotNowLink = $('#authorize-not-now-link');
            var inviteNotNowLink = $('#invite-not-now-link');

            inviteNotNowLink.click(function() {
                AJS.trigger('analyticsEvent', {name: 'notifications.hipchat.user.invite.wizard.dropout.invite.notnow', data: {}});
            });

            authorizeNotNowLink.click(function() {
                AJS.trigger('analyticsEvent', {name: 'notifications.hipchat.user.invite.wizard.dropout.authorize.notnow', data: {}});
            });

            var maxInvitationsPerRequest = inviteService.getMaxInvitationsPerRequest();
            $("#invite-explanation-message").html(AJS.I18n.getText("plugin.hipchat.admin.invite.explanation.message", maxInvitationsPerRequest));

            if (form.length == 0) {
                return;
            }

            // Prevent the "Are you sure you want to navigate away" dialog from appearing, only if we have a visible invite form
            window.onbeforeunload = null;

            form.on('user-picker-user-selected', function (e, user) {
                inviteService.addUser(user);
            });
            inviteeList.on('click', '.remove-invite-button', function (e) {
                e.preventDefault();
                var invitee = $(this).closest('.hipchat-invitee');
                inviteService.removeUser(invitee.attr('data-username'));
            });

            // Tooltips
            $('.hipchat-invitee-name-container').tipsy({live: true, gravity: 's'});
            $('.hipchat-invitee .email-container, .hipchat-invitee .aui-lozenge').tipsy({live: true, gravity: 'n'});

            function getEmailDomain(email) {
                var atIdx;
                if(email && (atIdx = email.indexOf('@')) && atIdx >= 0) {
                    return email.substr(atIdx);
                }
                // Fallback
                return email;
            }

            function renderUser(e, user) {
                if(!user.emailDomain) {
                    user.emailDomain = getEmailDomain(user.email);
                }
                inviteeList.append(inviteeTemplate(user));
                sendInvitesButton.prop('disabled', false);
                sendInvitesButton.removeAttr('aria-disabled');
            }

            function removeUser(e, username) {
                var invitee = inviteeList.find("[data-username='" + username + "']");
                invitee.remove();
                if (!inviteService.getUsers().length) {
                    sendInvitesButton.prop('disabled', true);
                    sendInvitesButton.attr('aria-disabled', true);
                }
            }

            function invitationProcessingStartedRenderer() {
                sendInvitesButton.attr('aria-disabled', true);

                var inviteProcessingIdleIndicators = $("[data-invite-processing='idle']");
                inviteProcessingIdleIndicators.addClass("hidden");

                var inviteProcessingRunningIndicators = $("[data-invite-processing='running']");
                inviteProcessingRunningIndicators.removeClass("hidden");

                var emailHolders = $(".email");
                emailHolders.hide();

                var removeButton = $(".remove-invite-button");
                removeButton.hide();
            }

            function invitationProcessingCompletedRenderer() {
                var inviteProcessingRunningIndicators = $("[data-invite-processing='running']");
                inviteProcessingRunningIndicators.addClass("hidden");

                var inviteProcessingIdleIndicators = $("[data-invite-processing='idle']");
                inviteProcessingIdleIndicators.removeClass("hidden");
            }

            function resultRenderer(userName, errorMessage) {
                var userDiv = $("[data-username='" + userName + "']");
                var successStatusHolder = userDiv.find(".aui-lozenge-success");
                var errorStatusHolder = userDiv.find(".aui-lozenge-current");
                if (errorMessage) {
                    errorStatusHolder.text(AJS.I18n.getText("plugin.hipchat.admin.invite.lozenge.error.message"));
                    errorStatusHolder.show();
                    successStatusHolder.hide();

                    errorStatusHolder.tooltip({
                        title: function () {
                            return errorMessage;
                        }
                    });
                } else {
                    successStatusHolder.text(AJS.I18n.getText("plugin.hipchat.admin.invite.lozenge.sent.message"));
                    successStatusHolder.show();
                    errorStatusHolder.hide();
                }
            }

            function renderDoneStep() {
                sendInvitesButton.hide();
                cancelButton.hide();
                doneButton.show();
                doneButton.removeAttr('aria-disabled');
                doneButton.removeAttr('disabled');
            }

            function errorRenderer(title, messageText, messageReason) {
                var messageContainer = $('#invite-banner-messages');
                messageContainer.empty();
                AJS.messages.error("#invite-banner-messages", {
                    title: title,
                    body: "<p>" + messageText + "<br/>" + messageReason + "</p>"
                });
            }

            inviteService.events.on('user-added.invite-hipchat', renderUser);
            inviteService.events.on('user-removed', removeUser);

            inviteService.initialise(
                invitationProcessingStartedRenderer,
                invitationProcessingCompletedRenderer,
                resultRenderer,
                renderDoneStep,
                errorRenderer);

            form.on('submit', function (e) {
                e.preventDefault();
                inviteService.sendInvitations();
            });

            doneButton.click(function (e) {
                e.preventDefault();
                inviteService.handleDone();
            });
        });
    });
