/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.tasks.HipChatTasksExecutor;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Internal
public class DefaultHipChatTasksExecutor
implements DisposableBean,
HipChatTasksExecutor {
    private ListeningScheduledExecutorService executorService;
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatTasksExecutor.class);

    public DefaultHipChatTasksExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hipchat-plugin-tasks-executor-%d").build();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)executor);
    }

    @Override
    public ListeningScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public <T> Promise<T> submit(Callable<T> task) {
        return this.runTask(task, (Runnable t) -> this.executorService.submit(t));
    }

    @Override
    public Promise<?> submit(Runnable task) {
        return Promises.forFuture((Future)this.executorService.submit(task), (Executor)this.executorService);
    }

    @Override
    public <V> Promise<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.runTask(task, (Runnable t) -> this.executorService.schedule(t, delay, unit));
    }

    @Override
    public Promise<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.runTask(task, (Runnable t) -> this.executorService.schedule(t, delay, unit));
    }

    public void destroy() {
        this.shutdown();
    }

    private <R> Promise<R> runTask(Callable<R> task, Consumer<Runnable> executor) {
        return this.runTask(task, (t, f) -> f.complete(t.call()), executor);
    }

    private <R> Promise<R> runTask(Runnable task, Consumer<Runnable> executor) {
        return this.runTask(task, (t, f) -> {
            t.run();
            f.complete(null);
        }, executor);
    }

    private <T, R> Promise<R> runTask(T task, ThrowingBiConsumer<T, CompletableFuture> onTask, Consumer<Runnable> executor) {
        CompletableFuture future = new CompletableFuture();
        executor.accept(() -> {
            try {
                onTask.accept(task, future);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return Promises.forCompletionStage(future);
    }

    private void shutdown() {
        List remainingTasks = this.executorService.shutdownNow();
        if (remainingTasks.size() > 0) {
            logger.info("Executor service shutting, {} pending tasks were cancelled.", (Object)remainingTasks.size());
        }
    }

    @FunctionalInterface
    private static interface ThrowingBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Throwable;
    }
}

