/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.link;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.atlassian.plugins.hipchat.link.HipChatLinkConverter;
import com.atlassian.plugins.hipchat.link.HipChatLinkManager;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;

@Internal
public class DefaultHipChatLinkManager
implements HipChatLinkManager {
    private final HipChatLinkConverter hipChatLinkConverter;
    private final HipChatAOLinkManager hipChatAOLinkManager;

    public DefaultHipChatLinkManager(HipChatLinkConverter hipChatLinkConverter, HipChatAOLinkManager hipChatAOLinkManager) {
        this.hipChatLinkConverter = hipChatLinkConverter;
        this.hipChatAOLinkManager = hipChatAOLinkManager;
    }

    @Override
    public Option<HipChatLink> getDefaultLink() {
        return Iterables.first(this.getLinks());
    }

    @Override
    public boolean isAnyLinkDefined() {
        return this.hipChatAOLinkManager.getLinks().iterator().hasNext();
    }

    @Override
    public Option<HipChatLink> getLinkById(HipChatLinkId id) {
        return this.hipChatAOLinkManager.getLinkById(id).map(this.hipChatLinkConverter.toHipChatLink());
    }

    public Iterable<HipChatLink> getLinks() {
        return Iterables.transform(this.hipChatAOLinkManager.getLinks(), this.hipChatLinkConverter.toHipChatLink());
    }

    @Override
    public Option<HipChatLink> getLinkByOAuthId(String oauthId) {
        return this.hipChatAOLinkManager.getLinkByOAuthId(oauthId).map(this.hipChatLinkConverter.toHipChatLink());
    }

    @Override
    public HipChatLink asLink(AOHipChatLink link) {
        return this.hipChatLinkConverter.toHipChatLink().apply(link);
    }

    @Override
    public Option<AOHipChatLink> asAOLink(HipChatLink link) {
        return this.hipChatAOLinkManager.getLinkById(link.getId());
    }
}

