/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.hipchat.api.ErrorResponse;
import com.atlassian.hipchat.api.ErrorResponseException;
import com.google.common.base.Throwables;
import io.atlassian.fugue.Option;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ResourceError {
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private final Option<Throwable> exception;
    private final int statusCode;
    private final Option<ErrorResponse> errorResponse;

    public ResourceError(ErrorResponse errorResponse) {
        this.statusCode = errorResponse.getError().getCode();
        this.errorResponse = Option.option((Object)errorResponse);
        this.exception = Option.none();
    }

    public ResourceError(Throwable throwable, int statusCode) {
        this.exception = Option.option((Object)throwable);
        this.statusCode = statusCode;
        this.errorResponse = this.extractErrorResponseFromThrowable(throwable);
    }

    public ResourceError(Throwable throwable) {
        this.exception = Option.option((Object)throwable);
        this.statusCode = this.extractStatusCodeFromThrowable(throwable);
        this.errorResponse = this.extractErrorResponseFromThrowable(throwable);
    }

    private Option<ErrorResponse> extractErrorResponseFromThrowable(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof ErrorResponseException) {
                return Option.some((Object)((ErrorResponseException)throwable).getErrorResponse());
            }
            return this.extractErrorResponseFromThrowable(throwable.getCause());
        }
        return Option.none();
    }

    private int extractStatusCodeFromThrowable(Throwable throwable) {
        Throwable rootCause;
        if (throwable != null && ((rootCause = Throwables.getRootCause((Throwable)throwable)) instanceof SocketTimeoutException || rootCause instanceof ConnectException)) {
            return 503;
        }
        return 500;
    }

    public Throwable toThrowable() {
        return (Throwable)this.exception.getOrElse(this.errorResponse.map(input -> new ErrorResponseException((ErrorResponse)input)).getOrNull());
    }

    @JsonProperty
    public int getStatusCode() {
        return this.statusCode;
    }

    @JsonProperty
    public String getMessage() {
        return (String)this.errorResponse.map(input -> input.getError().getMessage()).getOrElse(this.exception.map(input -> input.getMessage()).getOrElse((Object)""));
    }

    @JsonProperty
    private String getStackTrace() {
        if (ResourceError.isDevMode()) {
            return (String)this.exception.map(input -> {
                StringWriter stringWriter = new StringWriter();
                input.printStackTrace(new PrintWriter(stringWriter));
                return stringWriter.toString();
            }).getOrElse((Object)"");
        }
        return null;
    }

    @JsonIgnore
    public Option<ErrorResponse> getErrorResponse() {
        return this.errorResponse;
    }

    public String toString() {
        return "ResourceError{exception=" + this.exception + ", statusCode=" + this.statusCode + '}';
    }

    private static boolean isDevMode() {
        return Boolean.getBoolean("confluence.devmode") || Boolean.getBoolean("atlassian.dev.mode");
    }
}

