/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.user;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.user.InvitationTracker;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.apache.commons.lang3.StringUtils;

@Internal
public class DefaultInvitationTracker
implements InvitationTracker {
    private static final String PLUGIN_STORAGE_KEY_BASE = "com.atlassian.plugins.hipchat.user.invitation.tracker";
    private static final String INVITEES_SUGGESTED_KEY = "com.atlassian.plugins.hipchat.user.invitation.tracker.invitees.suggested";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginSettings pluginSettings;

    public DefaultInvitationTracker(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public boolean hasPreviouslySuggestedInvitees() {
        Object rawValue = this.pluginSettings.get(INVITEES_SUGGESTED_KEY);
        if (rawValue == null) {
            return false;
        }
        if (rawValue instanceof String) {
            String trimmedValue = StringUtils.trimToEmpty((String)rawValue.toString());
            return trimmedValue.equals("true");
        }
        return false;
    }

    @Override
    public void setInviteesSuggested(boolean inviteesSuggested) {
        String newValue = String.valueOf(inviteesSuggested);
        this.pluginSettings.put(INVITEES_SUGGESTED_KEY, (Object)newValue);
    }
}

