/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.rooms.impl;

import com.atlassian.annotations.Internal;
import com.atlassian.hipchat.api.AbstractMessage;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.MessageFormat;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.cards.Card;
import com.atlassian.hipchat.api.connect.descriptor.extensions.ExternalPage;
import com.atlassian.hipchat.api.connect.descriptor.extensions.GetExternalPage;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Glance;
import com.atlassian.hipchat.api.connect.descriptor.extensions.GlanceSummary;
import com.atlassian.hipchat.api.connect.descriptor.extensions.WebPanel;
import com.atlassian.hipchat.api.connect.descriptor.extensions.WebPanelSummary;
import com.atlassian.hipchat.api.glances.RoomAddonUiUpdateData;
import com.atlassian.hipchat.api.rooms.AllRoomsResult;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.hipchat.api.rooms.MessageContainer;
import com.atlassian.hipchat.api.rooms.RoomService;
import com.atlassian.hipchat.api.rooms.impl.NewRoom;
import com.atlassian.hipchat.api.rooms.impl.Room;
import com.atlassian.hipchat.api.users.RecentHistoryResult;
import com.atlassian.hipchat.api.webhooks.Message;
import com.sun.jersey.api.client.Client;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Internal
public final class DefaultRoomService
implements RoomService {
    private final HipChatRoutesProvider.Routes<?> routes;
    private Client client;
    private ClientResponseMapper mapper;
    private Function<Result<MessageContainer>, Result<Message>> onResult = input -> {
        if (input.isError()) {
            return input.asError();
        }
        return Result.success(((MessageContainer)input.success()).getValue());
    };

    public DefaultRoomService(HipChatRoutesProvider.Routes<?> routes, Client client, ClientResponseMapper mapper) {
        this.routes = routes;
        this.client = client;
        this.mapper = mapper;
    }

    @Override
    public AllRoomsRequestBuilder getAllRooms() {
        return new AllRoomsRequestBuilder();
    }

    @Override
    public Promise<Result<ExpandedRoom>> getRoom(String roomId) {
        return this.routes.getRoom(roomId).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(Room.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Message>> getRoomMessage(String roomNameOrId, String messageId) {
        return this.routes.getRoomMessage(roomNameOrId, messageId).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(MessageContainer.class)).map(this.onResult).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> sendMessage(String roomNameOrId, String message, MessageFormat messageFormat) {
        RoomMessage messageObj = new RoomMessage(message, messageFormat, false);
        return this.sendMessage(roomNameOrId, messageObj);
    }

    @Override
    public Promise<Result<Void>> sendMessage(String roomNameOrId, String message, MessageFormat messageFormat, MessageBgColor color) {
        RoomMessage messageObj = new RoomMessage(message, messageFormat, null, null, false, color);
        return this.sendMessage(roomNameOrId, messageObj);
    }

    @Override
    public Promise<Result<Void>> sendMessage(String roomNameOrId, String message, MessageFormat messageFormat, MessageBgColor color, Card card, boolean notify) {
        RoomMessage messageObj = new RoomMessage(message, messageFormat, card, null, notify, color);
        return this.sendMessage(roomNameOrId, messageObj);
    }

    @Override
    public Promise<Result<Void>> sendMessage(String roomNameOrId, String message, MessageFormat messageFormat, MessageBgColor color, Card card, String attachTo, boolean notify) {
        RoomMessage messageObj = new RoomMessage(message, messageFormat, card, attachTo, notify, color);
        return this.sendMessage(roomNameOrId, messageObj);
    }

    private Promise<Result<Void>> sendMessage(String roomNameOrId, RoomMessage messageObj) {
        return this.routes.sendRoomMessage(roomNameOrId).flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, messageObj, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<RecentHistoryResult>> viewRecentHistory(String roomNameOrId, Option<Integer> maxResults, Option<String> timezone, Option<String> notBefore) {
        return this.routes.viewRecentRoomHistory(roomNameOrId, maxResults, timezone, notBefore).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(RecentHistoryResult.class));
    }

    @Override
    public Promise<Result<ExpandedRoom>> createRoom(String roomName, String ownerUserId, Option<String> topic, Option<Boolean> guestAccess, Option<String> privacy) {
        NewRoom roomObj = new NewRoom(roomName, (String)topic.getOrNull(), (Boolean)guestAccess.getOrElse((Object)false), ownerUserId, (String)privacy.getOrElse((Object)"public"));
        return this.routes.createRoom().flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, roomObj, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.to(Room.class)).flatMap(input -> {
            if (input.isError()) {
                return Promises.promise(Result.error(input.error()));
            }
            return this.getRoom(((Room)input.success()).getId());
        }).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> deleteRoom(String roomNameOrId) {
        return this.routes.deleteRoom(roomNameOrId).flatMap(ResourceMapper.toDeleteAsyncJsonResource(this.client)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<GlanceSummary>> getRoomGlance(String roomNameOrId, String glanceKey) {
        return this.routes.getRoomGlance(roomNameOrId, glanceKey).flatMap(ResourceMapper.toGetAsync(this.client)).map(this.mapper.to(GlanceSummary.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> createRoomGlance(String roomNameOrId, Glance glance) {
        return this.routes.createRoomGlance(roomNameOrId, glance.getKey()).flatMap(ResourceMapper.toPutAsyncJsonResource(this.client, glance, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> deleteRoomGlance(String roomNameOrId, String glanceKey) {
        return this.routes.deleteRoomGlance(roomNameOrId, glanceKey).flatMap(ResourceMapper.toDeleteAsyncJsonResource(this.client)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> updateRoomAddonUiForUser(String roomNameOrId, String userIdOrEmail, RoomAddonUiUpdateData roomAddonUiUpdateData) {
        return this.routes.updateRoomAddonUiForUser(roomNameOrId, userIdOrEmail).flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, roomAddonUiUpdateData, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> updateRoomAddonUi(String roomNameOrId, RoomAddonUiUpdateData roomAddonUiUpdateData) {
        return this.routes.updateRoomAddonUi(roomNameOrId).flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, roomAddonUiUpdateData, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<WebPanelSummary>> getRoomWebPanel(String roomNameOrId, String webPanelKey) {
        return this.routes.getRoomWebPanel(roomNameOrId, webPanelKey).flatMap(ResourceMapper.toGetAsync(this.client)).map(this.mapper.to(WebPanelSummary.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> createRoomWebPanel(String roomNameOrId, WebPanel webPanel) {
        return this.routes.createRoomWebPanel(roomNameOrId, webPanel.getKey()).flatMap(ResourceMapper.toPutAsyncJsonResource(this.client, webPanel, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> deleteRoomWebPanel(String roomNameOrId, String webPanelKey) {
        return this.routes.deleteRoomWebPanel(roomNameOrId, webPanelKey).flatMap(ResourceMapper.toDeleteAsyncJsonResource(this.client)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> createRoomExternalPage(String roomNameOrId, ExternalPage externalPage) {
        return this.routes.roomExternalPage(roomNameOrId, externalPage.getKey()).flatMap(ResourceMapper.toPutAsyncJsonResource(this.client, externalPage, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> deleteRoomExternalPage(String roomNameOrId, String externalPageKey) {
        return this.routes.roomExternalPage(roomNameOrId, externalPageKey).flatMap(ResourceMapper.toDeleteAsyncJsonResource(this.client)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<GetExternalPage>> getRoomExternalPage(String roomNameOrId, String externalPageKey) {
        return this.routes.getRoomGlance(roomNameOrId, externalPageKey).flatMap(ResourceMapper.toGetAsync(this.client)).map(this.mapper.to(GetExternalPage.class)).recover(ResourceMapper.handleError());
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class RoomMessage
    extends AbstractMessage {
        private final Card card;
        private final MessageBgColor color;
        private final String attachTo;

        @JsonCreator
        public RoomMessage(@JsonProperty(value="message") String message, @JsonProperty(value="message_format") MessageFormat format, @JsonProperty(value="card") Card card, @JsonProperty(value="attach_to") String attachTo, @JsonProperty(value="notify") boolean notify, @JsonProperty(value="color") MessageBgColor color) {
            super(message, format, notify);
            this.card = card;
            this.color = color;
            this.attachTo = attachTo;
        }

        public RoomMessage(String message, MessageFormat format, boolean notify) {
            this(message, format, null, null, notify, MessageBgColor.GRAY);
        }

        public RoomMessage(String message, MessageBgColor color) {
            super(message);
            this.card = null;
            this.color = color;
            this.attachTo = null;
        }

        public RoomMessage(String message) {
            super(message);
            this.card = null;
            this.color = null;
            this.attachTo = null;
        }

        @JsonProperty(value="color")
        @Nullable
        public MessageBgColor getColor() {
            return this.color;
        }

        public Card getCard() {
            return this.card;
        }

        @JsonProperty(value="attach_to")
        public String getAttachTo() {
            return this.attachTo;
        }
    }

    public final class AllRoomsRequestBuilder
    implements RoomService.AllRoomsRequestBuilder {
        private Option<Integer> startIndex = Option.none();
        private Option<Integer> maxResults = Option.none();
        private Option<Boolean> includeArchived = Option.none();
        private Option<String> expansions = Option.none();
        private Option<Boolean> includePrivate;

        AllRoomsRequestBuilder() {
        }

        @Override
        public AllRoomsRequestBuilder startIndex(int startIndex) {
            this.startIndex = Option.some((Object)startIndex);
            return this;
        }

        @Override
        public AllRoomsRequestBuilder maxResults(int maxResults) {
            this.maxResults = Option.some((Object)maxResults);
            return this;
        }

        @Override
        public AllRoomsRequestBuilder includeArchived(boolean includeArchived) {
            this.includeArchived = Option.some((Object)includeArchived);
            return this;
        }

        @Override
        public RoomService.AllRoomsRequestBuilder includePrivate(boolean includePrivate) {
            this.includePrivate = Option.some((Object)includePrivate);
            return this;
        }

        @Override
        public AllRoomsRequestBuilder expand(String expansions) {
            this.expansions = Option.some((Object)expansions);
            return this;
        }

        @Override
        public Promise<Result<AllRoomsResult>> build() {
            return DefaultRoomService.this.routes.getAllRooms(this.startIndex, this.maxResults, this.includeArchived, this.includePrivate, this.expansions).flatMap(ResourceMapper.toGetAsyncJsonResource(DefaultRoomService.this.client)).map(DefaultRoomService.this.mapper.to(AllRoomsResult.class)).recover(ResourceMapper.handleError());
        }
    }
}

