/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.guava11.memory;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.GuavaAwareCacheFactory;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.cache.compat.guava11.memory.MemoryCache;
import com.atlassian.cache.compat.guava11.memory.MemoryCachedReference;
import com.atlassian.cache.compat.impl.AbstractCacheFactory;
import com.atlassian.cache.compat.impl.ReferenceKey;
import com.atlassian.cache.compat.impl.StrongSupplier;
import com.atlassian.cache.compat.impl.WeakSupplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import io.atlassian.util.concurrent.ManagedLock;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class MemoryCacheFactory
extends AbstractCacheFactory
implements GuavaAwareCacheFactory {
    @Override
    public <V> CachedReference<V> getCachedReference(String name, final Supplier<V> supplier, CacheSettings settings) {
        final CacheSettings overriddenSettings = settings.override(new CacheSettingsBuilder().flushable().maxEntries(1).build());
        return (CachedReference)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock(new java.util.function.Supplier<MemoryCachedReference<V>>(){

            @Override
            public MemoryCachedReference<V> get() {
                LoadingCache computingCache = MemoryCacheFactory.this.createCacheBuilder(overriddenSettings).build(new com.google.common.cache.CacheLoader<ReferenceKey, V>(){

                    public V load(ReferenceKey key) {
                        return supplier.get();
                    }
                });
                return MemoryCachedReference.create(computingCache);
            }
        });
    }

    @Override
    public Cache createSimpleCache(final String name, final CacheSettings settings) {
        Cache cache;
        Supplier cacheSupplier = (Supplier)this.caches.get(name);
        if (cacheSupplier != null && (cache = (Cache)cacheSupplier.get()) != null) {
            return cache;
        }
        return (Cache)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock((java.util.function.Supplier)new java.util.function.Supplier<Cache>(){

            @Override
            public Cache get() {
                if (!MemoryCacheFactory.this.caches.containsKey(name)) {
                    com.google.common.cache.Cache simpleCache = MemoryCacheFactory.this.createCacheBuilder(settings).build();
                    MemoryCache cache = MemoryCache.create(simpleCache, name, settings);
                    MemoryCacheFactory.this.caches.put(name, new StrongSupplier(cache));
                }
                return (Cache)((Supplier)MemoryCacheFactory.this.caches.get(name)).get();
            }
        });
    }

    @Override
    public <K, V> Cache createComputingCache(final String name, final CacheSettings settings, final CacheLoader<K, V> loader) {
        return (Cache)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock(new java.util.function.Supplier<MemoryCache<K, V>>(){

            @Override
            public MemoryCache<K, V> get() {
                LoadingCache computingCache = MemoryCacheFactory.this.createCacheBuilder(settings).build(new com.google.common.cache.CacheLoader<K, V>(){

                    public V load(@Nullable K key) {
                        return loader.load(key);
                    }
                });
                MemoryCache cache = MemoryCache.create(computingCache, name, settings);
                if (!MemoryCacheFactory.this.caches.containsKey(name)) {
                    MemoryCacheFactory.this.caches.put(name, new WeakSupplier(cache));
                }
                return cache;
            }
        });
    }

    private CacheBuilder<Object, Object> createCacheBuilder(CacheSettings settings) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (null != settings.getMaxEntries()) {
            cacheBuilder.maximumSize((long)settings.getMaxEntries().intValue());
        }
        if (null != settings.getExpireAfterAccess()) {
            cacheBuilder.expireAfterAccess(settings.getExpireAfterAccess().longValue(), TimeUnit.MILLISECONDS);
        } else if (null != settings.getExpireAfterWrite()) {
            cacheBuilder.expireAfterWrite(settings.getExpireAfterWrite().longValue(), TimeUnit.MILLISECONDS);
        }
        return cacheBuilder;
    }
}

