/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.user;

import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.session.GenerateTokenResult;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.atlassian.plugins.hipchat.link.HipChatLinkManager;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.plugins.hipchat.user.HipChatUserMapper;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Transactional
public class DefaultHipChatUserMapper
implements HipChatUserMapper {
    private final HipChatAOUserManager hipChatAOUserManager;
    private final HipChatAOLinkManager hipChatAOLinkManager;
    private final HipChatLinkManager hipChatLinkManager;

    public DefaultHipChatUserMapper(HipChatAOUserManager hipChatAOUserManager, HipChatAOLinkManager hipChatAOLinkManager, HipChatLinkManager hipChatLinkManager) {
        this.hipChatAOUserManager = hipChatAOUserManager;
        this.hipChatAOLinkManager = hipChatAOLinkManager;
        this.hipChatLinkManager = hipChatLinkManager;
    }

    @Override
    public Option<AOHipChatUser> mapHipChatUser(UserKey userKey, HipChatUserId hipChatUserId, String hipChatUserName, HipChatLink hipchatLink, Option<GenerateTokenResult> generateTokenResult, Set<HipChatScope> scopes) {
        AOHipChatLink aoLink = (AOHipChatLink)this.hipChatAOLinkManager.getLinkById(hipchatLink.getId()).get();
        return this.hipChatAOUserManager.create(userKey, hipChatUserId, hipChatUserName, aoLink, generateTokenResult, scopes);
    }

    @Override
    public boolean removeHipChatUserMapping(UserKey userKey) {
        Option<AOHipChatUser> aoHipChatUser = this.hipChatAOUserManager.getByUserKey(userKey);
        if (aoHipChatUser.isDefined()) {
            this.hipChatAOUserManager.delete((AOHipChatUser)aoHipChatUser.get());
        }
        return aoHipChatUser.isDefined();
    }

    @Override
    public Option<HipChatUserId> findHipChatUserId(UserKey userKey) {
        return this.hipChatAOUserManager.getByUserKey(userKey).map((Function)new Function<AOHipChatUser, HipChatUserId>(){

            public HipChatUserId apply(AOHipChatUser input) {
                return DefaultHipChatUserMapper.this.makeHipChatUserId(input);
            }
        });
    }

    @Override
    public Option<HipChatUserId> findHipChatUserIdWithPersonalToken(UserKey userKey) {
        return this.hipChatAOUserManager.getByUserKey(userKey).flatMap((Function)new Function<AOHipChatUser, Option<HipChatUserId>>(){

            public Option<HipChatUserId> apply(AOHipChatUser hipchatUser) {
                if (StringUtils.isNotBlank((CharSequence)hipchatUser.getUserToken())) {
                    return Option.some((Object)DefaultHipChatUserMapper.this.makeHipChatUserId(hipchatUser));
                }
                return Option.none();
            }
        });
    }

    private HipChatUserId makeHipChatUserId(AOHipChatUser hipchatUser) {
        return new HipChatUserId(hipchatUser.getHipChatUserId(), new HipChatLinkId(hipchatUser.getHipChatLink().getID()));
    }

    @Override
    public List<UserKey> findUserKeyFromHipChatUserId(HipChatUserId hipChatUserId) {
        Iterable<AOHipChatUser> byHipChatUserId = this.hipChatAOUserManager.getByHipChatUserId(hipChatUserId);
        return Lists.transform((List)Lists.newArrayList(byHipChatUserId), (Function)new Function<AOHipChatUser, UserKey>(){

            public UserKey apply(AOHipChatUser input) {
                return new UserKey(input.getUserKey());
            }
        });
    }

    @Override
    public Option<UserKey> findUserKeyFromHipChatUserIdInDefaultLink(final String hipChatUserId) {
        return this.hipChatLinkManager.getDefaultLink().flatMap((Function)new Function<HipChatLink, Option<UserKey>>(){

            public Option<UserKey> apply(HipChatLink link) {
                HipChatUserId id = new HipChatUserId(hipChatUserId, link.getId());
                List<UserKey> keys = DefaultHipChatUserMapper.this.findUserKeyFromHipChatUserId(id);
                return keys.isEmpty() ? Option.none() : Option.some((Object)keys.get(0));
            }
        });
    }

    @Override
    public Option<Pair<HipChatUserId, String>> findHipChatUserIdAndName(UserKey userKey) {
        return this.hipChatAOUserManager.getByUserKey(userKey).map((Function)new Function<AOHipChatUser, Pair<HipChatUserId, String>>(){

            public Pair<HipChatUserId, String> apply(AOHipChatUser input) {
                return Pair.pair((Object)new HipChatUserId(input.getHipChatUserId(), new HipChatLinkId(input.getHipChatLink().getID())), (Object)input.getHipChatUserName());
            }
        });
    }
}

