/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.link;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptor;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.link.ConnectDescriptorLoader;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultConnectDescriptorLoader
implements ConnectDescriptorLoader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConnectDescriptorLoader.class);
    private final HipChatAOLinkManager hipChatAOLinkManager;

    public DefaultConnectDescriptorLoader(HipChatAOLinkManager hipChatAOLinkManager) {
        this.hipChatAOLinkManager = (HipChatAOLinkManager)Preconditions.checkNotNull((Object)hipChatAOLinkManager);
    }

    @Override
    public Option<ConnectDescriptor> loadConnectDescriptor(HipChatLinkId hipChatLinkId) {
        ConnectDescriptor connectDescriptor;
        AOHipChatLink aoHipChatLink;
        String connectDescriptorJson;
        Option<AOHipChatLink> aoHipChatLinkOption = this.hipChatAOLinkManager.getLinkById(hipChatLinkId);
        Option connectDescriptorOption = aoHipChatLinkOption.isDefined() ? ((connectDescriptorJson = (aoHipChatLink = (AOHipChatLink)aoHipChatLinkOption.get()).getConnectDescriptor()) != null && connectDescriptorJson.length() > 0 ? ((connectDescriptor = this.parseConnectDescriptor(connectDescriptorJson)) == null ? Option.none(ConnectDescriptor.class) : Option.option((Object)connectDescriptor)) : Option.none(ConnectDescriptor.class)) : Option.none(ConnectDescriptor.class);
        return connectDescriptorOption;
    }

    private ConnectDescriptor parseConnectDescriptor(String connectDescriptorJson) {
        try {
            return ConnectDescriptor.parseJson(connectDescriptorJson);
        }
        catch (RuntimeException e) {
            logger.warn("Unable to parse connect descriptor {0}", (Object)connectDescriptorJson);
            return null;
        }
    }
}

