/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.compat;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPI;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPIService;
import com.atlassian.plugins.hipchat.api.compat.HipChatV2APIService;
import com.atlassian.plugins.hipchat.api.compat.NoOpNotificationService;
import com.atlassian.plugins.hipchat.api.compat.legacy.HipChatV1APIService;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.util.concurrent.Promise;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class DefaultHipChatCompatApi
implements HipChatCompatAPI {
    private HipChatCompatAPIService v2APIService;
    private HipChatCompatAPIService v1APIService;
    private HipChatCompatAPIService noOpService;

    public DefaultHipChatCompatApi(HipChatV2APIService v2APIService, HipChatV1APIService v1APIService) {
        this.v2APIService = v2APIService;
        this.v1APIService = v1APIService;
        this.noOpService = new NoOpNotificationService();
    }

    private HipChatCompatAPIService getCurrentApi() {
        if (this.v2APIService.isEnabled()) {
            return this.v2APIService;
        }
        if (this.v1APIService.isEnabled()) {
            return this.v1APIService;
        }
        return this.noOpService;
    }

    @Override
    public boolean isEnabled() {
        return this.getCurrentApi().isEnabled();
    }

    @Override
    public void notifyUser(@Nonnull String toID, @Nonnull String msg) throws ResponseException {
        this.getCurrentApi().notifyUser(toID, msg);
    }

    @Override
    public void notifyUser(@Nonnull String toId, @Nonnull String msg, @Nonnull HipChatNotificationOptions optinos) throws ResponseException {
        this.getCurrentApi().notifyUser(toId, msg, optinos);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg) throws ResponseException {
        this.getCurrentApi().notifyRoom(toID, msg);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) throws ResponseException {
        this.getCurrentApi().notifyRoom(toID, msg, options);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color) throws ResponseException {
        this.getCurrentApi().notifyRoom(toID, msg, color);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color, boolean notifyClients) throws ResponseException {
        this.getCurrentApi().notifyRoom(toID, msg, color, notifyClients);
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllPublicRooms() {
        return this.getCurrentApi().getAllPublicRooms();
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllRooms() {
        return this.getCurrentApi().getAllRooms();
    }

    @Override
    public Promise<Map<String, Result<ExpandedRoom>>> expandRoomsForIds(Iterable<String> roomIds) {
        return this.getCurrentApi().expandRoomsForIds(roomIds);
    }

    @Override
    public HipChatCompatAPIService.Version getCurrentVersion() {
        return this.getCurrentApi().getCurrentVersion();
    }

    @Override
    public Option<String> getGroupName() {
        return this.getCurrentApi().getGroupName();
    }

    @Override
    public Option<String> getApiUrl() {
        return this.getCurrentApi().getApiUrl();
    }

    @Override
    public Promise<Result<ExpandedRoom>> createRoom(String name, HipChatUserId owner, Option<String> topic) {
        return this.getCurrentApi().createRoom(name, owner, topic);
    }

    @Override
    public Promise<Result<Void>> deleteRoom(String roomNameOrId) {
        return this.getCurrentApi().deleteRoom(roomNameOrId);
    }

    @Override
    public Promise<Result<Boolean>> userExists(String emailAddress) {
        return this.getCurrentApi().userExists(emailAddress);
    }
}

