/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.client;

import com.atlassian.fugue.Option;
import com.atlassian.plugins.hipchat.api.client.RateLimitStateService;
import com.sun.jersey.api.client.ClientResponse;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRateLimitStateService
implements RateLimitStateService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRateLimitStateService.class);
    private RateLimitStateService.RateLimitState state = null;
    private long clockSkew = 0L;

    @Override
    public void setRateLimitState(ClientResponse response) {
        try {
            MultivaluedMap headers = response.getHeaders();
            String limit = (String)headers.getFirst((Object)"X-Ratelimit-Limit");
            String remaining = (String)headers.getFirst((Object)"X-Ratelimit-Remaining");
            String reset = (String)headers.getFirst((Object)"X-Ratelimit-Reset");
            if (limit != null && remaining != null && reset != null) {
                long millisecondsUntilReset = this.adaptUnixTimestamp(reset) - System.currentTimeMillis();
                if (millisecondsUntilReset < 0L && this.clockSkew < -millisecondsUntilReset) {
                    logger.warn("Detected clock skew: " + this.clockSkew);
                    this.clockSkew = -millisecondsUntilReset;
                }
                this.state = new RateLimitStateService.RateLimitState(Long.parseLong(limit), Long.parseLong(remaining), millisecondsUntilReset + this.clockSkew);
            }
        }
        catch (Exception e) {
            logger.warn("Exception getting rate limit state from response", (Throwable)e);
        }
    }

    @Override
    public Option<RateLimitStateService.RateLimitState> getRateLimitState() {
        return Option.option((Object)this.state);
    }

    private long adaptUnixTimestamp(String value) {
        if (value.contains(".")) {
            value = value.substring(0, value.indexOf("."));
        }
        return Long.parseLong(value + "000");
    }
}

