/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.rooms.impl;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.json.OptionJsonSerializer;
import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.atlassian.hipchat.api.rooms.CollapsedStatistics;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.hipchat.api.rooms.RoomPrivacy;
import com.atlassian.hipchat.api.rooms.impl.Statistics;
import com.atlassian.hipchat.api.users.CollapsedUser;
import com.atlassian.hipchat.api.users.User;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
@Internal
public final class Room
implements ExpandedRoom {
    public static final String JSON_PROPERTY_ID = "id";
    public static final String JSON_PROPERTY_LINKS = "links";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_CREATED = "created";
    public static final String JSON_PROPERTY_LAST_ACTIVE = "last_active";
    public static final String JSON_PROPERTY_IS_ARCHIVED = "is_archived";
    public static final String JSON_PROPERTY_IS_GUEST_ACCESSIBLE = "is_guest_accessible";
    public static final String JSON_PROPERTY_OWNER = "owner";
    public static final String JSON_PROPERTY_PARTICIPANTS = "participants";
    public static final String JSON_PROPERTY_PRIVACY = "privacy";
    public static final String JSON_PROPERTY_STATISTICS = "statistics";
    public static final String JSON_PROPERTY_TOPIC = "topic";
    public static final String JSON_PROPERTY_XMPP_JID = "xmpp_jid";
    public static final String JSON_PROPERTY_GUEST_ACCESS_URL = "guest_access_url";
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="links")
    @JsonSerialize(keyAs=String.class, contentAs=URI.class)
    private final Map<String, URI> links;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="created")
    private Date created;
    @JsonProperty(value="last_active")
    private Date lastActive;
    @JsonProperty(value="guest_access_url")
    @JsonSerialize(using=OptionJsonSerializer.class)
    private Option<URI> guestAccessUrl;
    @JsonProperty(value="is_archived")
    private boolean isArchived;
    @JsonProperty(value="is_guest_accessible")
    private boolean isGuestAccessible;
    @JsonSerialize(contentAs=User.class)
    @JsonProperty(value="owner")
    private CollapsedUser owner;
    @JsonSerialize(contentAs=User.class)
    @JsonProperty(value="participants")
    private List<CollapsedUser> participants;
    @JsonProperty(value="privacy")
    private RoomPrivacy privacy;
    @JsonSerialize(as=Statistics.class)
    @JsonProperty(value="statistics")
    private CollapsedStatistics statistics;
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="xmpp_jid")
    private String xmppJid;

    @JsonCreator
    public Room(@JsonProperty(value="id") String id, @JsonDeserialize(keyAs=String.class, contentAs=URI.class) @JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="name") String name, @JsonProperty(value="created") Date created, @JsonProperty(value="last_active") Date lastActive, @JsonProperty(value="guest_access_url") URI guestAccessUrl, @JsonProperty(value="is_archived") boolean isArchived, @JsonProperty(value="is_guest_accessible") boolean isGuestAccessible, @JsonDeserialize(as=User.class) @JsonProperty(value="owner") CollapsedUser owner, @JsonDeserialize(contentAs=User.class) @JsonProperty(value="participants") List<CollapsedUser> participants, @JsonProperty(value="privacy") String privacy, @JsonDeserialize(as=Statistics.class) @JsonProperty(value="statistics") CollapsedStatistics statistics, @JsonProperty(value="topic") String topic, @JsonProperty(value="xmpp_jid") String xmppJid) {
        this.id = id;
        this.links = links;
        this.name = name;
        this.created = created;
        this.lastActive = lastActive;
        this.guestAccessUrl = Option.option((Object)guestAccessUrl);
        this.isArchived = isArchived;
        this.isGuestAccessible = isGuestAccessible;
        this.owner = owner;
        this.participants = participants;
        this.privacy = StringUtils.isBlank((CharSequence)privacy) ? Room.privacyFromLinks(links) : RoomPrivacy.valueOf(privacy.toUpperCase());
        this.statistics = statistics;
        this.topic = topic;
        this.xmppJid = xmppJid;
    }

    private Room(String roomId, String roomName, RoomPrivacy roomPrivacy) {
        this.id = roomId;
        this.name = roomName;
        this.privacy = roomPrivacy;
        this.links = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public ExpandedRoom expanded() {
        return this;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getLastActive() {
        return this.lastActive;
    }

    @Override
    public Option<URI> getGuestAccessUrl() {
        return this.guestAccessUrl;
    }

    @Override
    public boolean getIsArchived() {
        return this.isArchived;
    }

    @Override
    public boolean getIsGuestAccessible() {
        return this.isGuestAccessible;
    }

    @Override
    public CollapsedUser getOwner() {
        return this.owner;
    }

    @Override
    public List<CollapsedUser> getParticipants() {
        return this.participants;
    }

    @Override
    public RoomPrivacy getPrivacy() {
        return this.privacy;
    }

    @Override
    public boolean isPrivate() {
        return RoomPrivacy.PRIVATE.equals((Object)this.getPrivacy());
    }

    @Override
    public CollapsedStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getXmppJid() {
        return this.xmppJid;
    }

    public static CollapsedRoom collapsed(String roomName, String roomId, RoomPrivacy roomPrivacy) {
        return new Room(roomId, roomName, roomPrivacy);
    }

    public static CollapsedRoom collapsed(String roomName, String roomId, RoomPrivacy roomPrivacy, boolean isGuest) {
        Room room = new Room(roomId, roomName, roomPrivacy);
        room.isGuestAccessible = isGuest;
        return room;
    }

    private static RoomPrivacy privacyFromLinks(Map<String, URI> links) {
        boolean isPrivate = links != null && links.containsKey("members");
        return isPrivate ? RoomPrivacy.PRIVATE : RoomPrivacy.PUBLIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room room = (Room)o;
        return this.id.equals(room.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Room{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", links=").append(this.links);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", created=").append(this.created);
        sb.append(", guestAccessUrl=").append(this.guestAccessUrl);
        sb.append(", isArchived=").append(this.isArchived);
        sb.append(", isGuestAccessible=").append(this.isGuestAccessible);
        sb.append(", owner=").append(this.owner);
        sb.append(", participants=").append(this.participants);
        sb.append(", privacy=").append((Object)this.privacy);
        sb.append(", statistics=").append(this.statistics);
        sb.append(", topic='").append(this.topic).append('\'');
        sb.append(", xmppJid='").append(this.xmppJid).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

