/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor.extensions;

import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Condition;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Icon;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Name;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class Glance
implements HipChatCapability,
Comparable<Glance> {
    private final String key;
    private final Name name;
    private final List<Condition> conditions;
    private final Icon icon;
    private final String queryUrl;
    private final String target;

    @JsonCreator
    public Glance(@JsonProperty(value="key") String key, @JsonProperty(value="name") Name name, @JsonProperty(value="conditions") Condition[] conditions, @JsonProperty(value="icon") Icon icon, @JsonProperty(value="queryUrl") String queryUrl, @JsonProperty(value="target") String target) {
        this.key = key;
        this.name = name;
        this.conditions = conditions != null ? Arrays.asList(conditions) : Collections.emptyList();
        this.icon = icon;
        this.queryUrl = queryUrl;
        this.target = target;
    }

    public String getKey() {
        return this.key;
    }

    public Name getName() {
        return this.name;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Glance glance = (Glance)o;
        if (!this.conditions.equals(glance.conditions)) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(glance.icon) : glance.icon != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(glance.key) : glance.key != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(glance.name) : glance.name != null) {
            return false;
        }
        if (this.queryUrl != null ? !this.queryUrl.equals(glance.queryUrl) : glance.queryUrl != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(glance.target) : glance.target != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.queryUrl != null ? this.queryUrl.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Glance{key='" + this.key + '\'' + ", name=" + this.name + ", conditions=" + this.conditions + ", icon=" + this.icon + ", queryUrl='" + this.queryUrl + '\'' + ", target='" + this.target + '\'' + '}';
    }

    @Override
    public int compareTo(Glance other) {
        Preconditions.checkNotNull((Object)other);
        int compare = ObjectUtils.compare((Comparable)((Object)this.key), (Comparable)((Object)other.key));
        if (compare == 0 && (compare = ObjectUtils.compare((Comparable)this.name, (Comparable)other.name)) == 0 && (compare = ObjectUtils.compare((Comparable)this.icon, (Comparable)other.icon)) == 0 && (compare = ObjectUtils.compare((Comparable)((Object)this.queryUrl), (Comparable)((Object)other.queryUrl))) == 0) {
            compare = ObjectUtils.compare((Comparable)((Object)this.target), (Comparable)((Object)other.target));
        }
        return compare;
    }
}

