/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor.extensions;

import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import java.net.URL;
import org.apache.commons.lang.ObjectUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Configurable
implements HipChatCapability,
Comparable<Configurable> {
    private final boolean allowAccessToRoomAdmins;
    private final Authentication authentication;
    private final URL url;

    @JsonCreator
    public Configurable(@JsonProperty(value="allowAccessToRoomAdmins") boolean allowAccessToRoomAdmins, @JsonProperty(value="authentication") Authentication authentication, @JsonProperty(value="url") URL url) {
        this.allowAccessToRoomAdmins = allowAccessToRoomAdmins;
        this.authentication = authentication;
        this.url = url;
    }

    public boolean isAllowAccessToRoomAdmins() {
        return this.allowAccessToRoomAdmins;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public int compareTo(Configurable other) {
        int compare = ObjectUtils.compare((Comparable)((Object)this.url.toString()), (Comparable)((Object)other.url.toString()));
        if (compare == 0 && (compare = ObjectUtils.compare((Comparable)Boolean.valueOf(this.allowAccessToRoomAdmins), (Comparable)Boolean.valueOf(other.allowAccessToRoomAdmins))) == 0) {
            compare = ObjectUtils.compare((Comparable)((Object)this.authentication), (Comparable)((Object)other.authentication));
        }
        return compare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configurable that = (Configurable)o;
        if (this.isAllowAccessToRoomAdmins() != that.isAllowAccessToRoomAdmins()) {
            return false;
        }
        if (this.getAuthentication() != that.getAuthentication()) {
            return false;
        }
        return this.getUrl().equals(that.getUrl());
    }

    public int hashCode() {
        int result = this.isAllowAccessToRoomAdmins() ? 1 : 0;
        result = 31 * result + this.getAuthentication().hashCode();
        result = 31 * result + this.getUrl().hashCode();
        return result;
    }

    public String toString() {
        return "Configurable{allowAccessToRoomAdmins=" + this.allowAccessToRoomAdmins + ", authentication=" + (Object)((Object)this.authentication) + ", url=" + this.url + '}';
    }

    public static enum Authentication {
        jwt,
        none;

    }
}

