/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import java.util.Arrays;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HipChatApiConsumer
implements HipChatCapability {
    private HipChatScope[] scopes;
    private String fromName;

    @JsonCreator
    public HipChatApiConsumer(@JsonProperty(value="fromName") String fromName, HipChatScope ... scopes) {
        this.scopes = this.cloneAndSortScopes(scopes);
        this.fromName = fromName;
    }

    @JsonSerialize(contentUsing=HipChatScope.HipChatScopeSerializer.class)
    public HipChatScope[] getScopes() {
        return this.scopes;
    }

    public String getFromName() {
        return this.fromName;
    }

    private HipChatScope[] cloneAndSortScopes(HipChatScope ... unsortedScopes) {
        HipChatScope[] copyOfScopes = Arrays.copyOf(unsortedScopes, unsortedScopes.length);
        Arrays.sort((Object[])copyOfScopes);
        return copyOfScopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HipChatApiConsumer)) {
            return false;
        }
        HipChatApiConsumer that = (HipChatApiConsumer)o;
        if (this.fromName != null ? !this.fromName.equals(that.fromName) : that.fromName != null) {
            return false;
        }
        return Arrays.equals((Object[])this.scopes, (Object[])that.scopes);
    }

    public int hashCode() {
        int result = this.scopes != null ? Arrays.hashCode((Object[])this.scopes) : 0;
        result = 31 * result + (this.fromName != null ? this.fromName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HipChatApiConsumer{fromName='" + this.fromName + '\'' + ", scopes=" + Arrays.toString((Object[])this.scopes) + '}';
    }
}

