package com.atlassian.plugins.avatar;


import java.util.function.Function;

/**
 * A convenience base class for implementers who want to avatar URLs without any native owner or avatar domain objects.
 */
abstract public class BaseAvatarProvider<T, I> implements AvatarProvider<T, I> {

    /**
     * Delegates to {@link #getAvatar(String, int)}.
     */
    @Override
    public Avatar getAvatar(final AvatarOwner<T> avatarOwner, final int size) {
        return getAvatar(avatarOwner.getIdentifier(), size);
    }

    /**
     * Not implemented.
     * @throws java.lang.UnsupportedOperationException
     */
    @Override
    public Avatar getAvatarById(final I avatarId, final int size) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /**
     * Delegates to {@link #getAvatar(AvatarOwner, int)}
     */
    @Override
    public Avatar getAvatar(AvatarOwner<T> owner, Function<AvatarOwner<T>, Avatar> fallbackFunction, int size) {
        return getAvatar(owner, size);
    }
}
