/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.usercontext.impl.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.StashComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.sso.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.sso.web.usercontext.PrincipalResolver;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.user.UserManager;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@BitbucketComponent
@StashComponent
@ConfluenceComponent
@FecruComponent
@BambooComponent
public class EmbeddedCrowdPrincipalResolver
implements PrincipalResolver {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCrowdPrincipalResolver.class);
    private final AuthenticationController authenticationController;
    private final CrowdService crowdService;
    private final UserManager userManager;

    @Inject
    public EmbeddedCrowdPrincipalResolver(@ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdService crowdService, @ComponentImport UserManager userManager) {
        this.authenticationController = authenticationController;
        this.crowdService = crowdService;
        this.userManager = userManager;
    }

    @Override
    public Optional<Principal> resolvePrincipal(String username, HttpServletRequest request) {
        try {
            this.crowdService.userAuthenticated(username);
            return Optional.ofNullable(this.userManager.resolve(username));
        }
        catch (OperationFailedException e) {
            throw new AuthenticationFailedException("Error authenticating user", e);
        }
        catch (InactiveAccountException | UserNotFoundException e) {
            log.debug("Exception caught when looking for user, treating user as not found", e);
            return Optional.empty();
        }
    }

    @Override
    public boolean isAllowedToAuthenticate(Principal principal, HttpServletRequest request) {
        return this.authenticationController.canLogin(principal, request);
    }
}

