/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.loginform;

import com.atlassian.plugins.authentication.sso.config.CachingSsoConfigService;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.DisableBasicAuthBlockRequestChecker;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.DisableNativeLoginAuthResponseWriter;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableNativeLoginAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DisableNativeLoginAuthFilter.class);
    private final DisableNativeLoginAuthResponseWriter responseWriter;
    private final CachingSsoConfigService cachingSsoConfigService;
    private final List<DisableBasicAuthBlockRequestChecker> blockRequestChecks;

    @Inject
    public DisableNativeLoginAuthFilter(DisableNativeLoginAuthResponseWriter disableBasicAuthResponseWriter, CachingSsoConfigService cachingSsoConfigService, List<DisableBasicAuthBlockRequestChecker> blockRequestChecks) {
        this.responseWriter = disableBasicAuthResponseWriter;
        this.cachingSsoConfigService = cachingSsoConfigService;
        this.blockRequestChecks = blockRequestChecks;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        Result result = this.checkRequest(request);
        if (result == Result.BLOCK_REQUEST) {
            log.trace("Blocking HTTP request - Native Login is not allowed: {}", (Object)request.getRequestURI());
            this.responseWriter.write(request, response);
        } else {
            log.trace("Allowing HTTP request: {}", (Object)request.getRequestURI());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private Result checkRequest(HttpServletRequest request) {
        if (!this.isNativeLoginEnabled() && this.isNativeAuthenticationRequest(request)) {
            return Result.BLOCK_REQUEST;
        }
        return Result.ALLOW_REQUEST;
    }

    private boolean isNativeAuthenticationRequest(HttpServletRequest request) {
        return this.blockRequestChecks.stream().anyMatch(check -> check.test(request));
    }

    private boolean isNativeLoginEnabled() {
        return this.cachingSsoConfigService.getSsoConfig().getShowLoginForm() || this.cachingSsoConfigService.getSsoConfig().enableAuthenticationFallback();
    }

    public void destroy() {
    }

    private static enum Result {
        BLOCK_REQUEST,
        ALLOW_REQUEST;

    }
}

