/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.saml;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.JustInTimeConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.impl.web.AbstractConsumerServlet;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.impl.web.AuthenticationRequest;
import com.atlassian.plugins.authentication.impl.web.SessionData;
import com.atlassian.plugins.authentication.impl.web.SessionDataService;
import com.atlassian.plugins.authentication.impl.web.saml.SamlAssertionValidationService;
import com.atlassian.plugins.authentication.impl.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlProvider;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlResponse;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.impl.web.usercontext.PrincipalResolver;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.ProvisioningService;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping.MappingExpression;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping.SamlUserDataFromIdpMapper;
import com.atlassian.plugins.authentication.impl.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlConsumerServlet
extends AbstractConsumerServlet {
    private static final Logger log = LoggerFactory.getLogger(SamlConsumerServlet.class);
    public static final String URL = "/plugins/servlet/samlconsumer";
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";
    public static final String RELAY_STATE_QUERY_PARAM = "RelayState";
    private final SsoConfigService ssoConfigService;
    private final SamlProvider samlProvider;
    private final SamlAssertionValidationService samlAssertionValidationService;
    private final AuthenticationHandlerProvider authenticationHandlerProvider;
    private final SamlUserDataFromIdpMapper mapper;

    @Inject
    public SamlConsumerServlet(@ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService, PrincipalResolver principalResolver, SamlProvider samlProvider, SessionDataService sessionDataService, SamlAssertionValidationService samlAssertionValidationService, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport I18nResolver i18nResolver, RememberMeCookieHandler rememberMeCookieHandler, ApplicationStateValidator applicationStateValidator, AuthenticationHandlerProvider authenticationHandlerProvider, ProvisioningService provisioningService, SamlUserDataFromIdpMapper mapper, EventPublisher eventPublisher) {
        super(applicationProperties, principalResolver, sessionDataService, authenticationListener, i18nResolver, rememberMeCookieHandler, applicationStateValidator, eventPublisher, ssoConfigService, provisioningService);
        this.ssoConfigService = ssoConfigService;
        this.samlProvider = samlProvider;
        this.samlAssertionValidationService = samlAssertionValidationService;
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.mapper = mapper;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Received SAML POST payload");
        this.applicationStateValidator.checkCanProcessAuthenticationRequest();
        Optional<SessionData> sessionData = this.sessionDataService.getSessionData(request, response, request.getParameter(RELAY_STATE_QUERY_PARAM));
        Optional<AuthenticationRequest> samlRequest = sessionData.map(SessionData::getAuthenticationRequest);
        String username = null;
        try {
            String finalUsername;
            Principal resolvedPrincipal;
            SamlResponse samlResponse = this.samlProvider.extractSamlResponse(request, response, this.getServiceProviderInfo(), samlRequest.orElse(null));
            this.applicationStateValidator.checkHasAppropriateLicenseForSamlResponse(samlResponse);
            this.samlAssertionValidationService.validateAssertionId(samlResponse);
            SamlConfig samlConfig = this.ssoConfigService.getSamlConfigOrFail();
            username = this.getUsername(samlResponse, samlConfig);
            JustInTimeConfig jitConfig = samlConfig.getJustInTimeConfig();
            if (jitConfig.isEnabled().orElse(false).booleanValue()) {
                this.handleJustInTimeProvisioning(this.mapper.mapUser(samlResponse, username), request);
            }
            if (!this.principalResolver.isAllowedToAuthenticate(resolvedPrincipal = this.principalResolver.resolvePrincipal(finalUsername = username, request).orElseThrow(() -> new AuthenticationFailedException("Received SSO request for user " + finalUsername + ", but the user does not exist")), request)) {
                throw new AuthenticationFailedException("Received SSO request for user " + username + ", but the user is not permitted to log in");
            }
            this.authenticationSuccess(request, response, resolvedPrincipal, "saml.authentication.successful");
            String redirectUrl = this.sessionDataService.extractTargetUrlOrReturnBaseUrl(sessionData);
            log.debug("Authenticated user {}, redirecting to {}", (Object)resolvedPrincipal.getName(), (Object)redirectUrl);
            this.refreshRememberMeCookieIfNeeded(samlConfig, request, response, samlResponse, resolvedPrincipal);
            response.sendRedirect(redirectUrl);
        }
        catch (InvalidSamlResponse e) {
            log.warn("Received an invalid SamlResponse: {}", (Object)e.toString());
            e.setTargetUrl(sessionData.flatMap(SessionData::getTargetUrl).map(URI::toString).orElse(null));
            this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(this.i18nResolver.createMessage("saml.authentication.invalidsamlresponse", new Serializable[]{request.getRemoteAddr()})), request, response);
            throw e;
        }
        catch (AuthenticationFailedException e) {
            log.debug("Failed to authenticate: {}", (Object)e.toString());
            this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(this.i18nResolver.createMessage("saml.authentication.authenticationfailed", new Serializable[]{username})), request, response);
            throw e;
        }
    }

    private void refreshRememberMeCookieIfNeeded(SsoConfig ssoConfig, HttpServletRequest request, HttpServletResponse response, SamlResponse samlResponse, Principal principal) {
        if (ssoConfig.isEnableRememberMe() || this.hasRememberMeFlagFromCrowd(samlResponse)) {
            this.rememberMeCookieHandler.refreshRememberMeCookie(request, response, principal);
            log.debug("Refreshed 'remember me' cookie for {}", (Object)principal.getName());
        }
    }

    private boolean hasRememberMeFlagFromCrowd(SamlResponse samlResponse) {
        Iterable<String> attributeValues = samlResponse.getAttribute("atl.crowd.properties.remember_me");
        return attributeValues != null && StreamSupport.stream(attributeValues.spliterator(), false).anyMatch(Boolean::parseBoolean);
    }

    private String getUsername(@Nonnull SamlResponse samlResponse, @Nonnull SamlConfig samlConfig) {
        String rawExpression = Strings.isNullOrEmpty((String)samlConfig.getUsernameAttribute()) ? "${NameID}" : samlConfig.getUsernameAttribute();
        MappingExpression expression = new MappingExpression(rawExpression);
        return expression.evaluateWithValues(varName -> this.getAttributeOrNameId(samlResponse, (String)varName));
    }

    private String getAttributeOrNameId(SamlResponse response, String key) {
        return "NameID".equalsIgnoreCase(key) ? response.getNameId() : (String)Iterables.getOnlyElement(response.getAttribute(key));
    }

    private SamlProvider.ServiceProviderInfo getServiceProviderInfo() {
        AuthenticationHandler authenticationHandler = this.authenticationHandlerProvider.getAuthenticationHandlerUnchecked(SsoType.SAML);
        return new SamlProvider.ServiceProviderInfo(authenticationHandler.getIssuerUrl(), authenticationHandler.getConsumerServletUrl());
    }
}

