/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.authentication;

import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.impl.web.filter.authentication.AuthenticationFilter;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;

public class ServiceDeskAuthenticationFilter
extends AuthenticationFilter {
    public static final String SERVICE_DESK_DESTINATION_QUERY_PARAM = "destination";
    public static final String SERVICE_DESK_PSEUDO_ABSOLUTE_REDIRECT_QUERY_PARAM = "absolute";
    private final TargetUrlNormalizer targetUrlNormalizer;

    public ServiceDeskAuthenticationFilter(AuthenticationHandlerProvider authenticationHandlerProvider, SsoConfigService ssoConfigService, TargetUrlNormalizer targetUrlNormalizer) {
        super(authenticationHandlerProvider, ssoConfigService);
        this.targetUrlNormalizer = targetUrlNormalizer;
    }

    @Override
    @Nullable
    protected String extractRequestedUrl(HttpServletRequest req) {
        String destination = Strings.emptyToNull((String)req.getParameter(SERVICE_DESK_DESTINATION_QUERY_PARAM));
        if (destination == null) {
            return null;
        }
        URI targetUrl = this.targetUrlNormalizer.getRelativeTargetUrl(destination);
        if (Boolean.parseBoolean(req.getParameter(SERVICE_DESK_PSEUDO_ABSOLUTE_REDIRECT_QUERY_PARAM))) {
            return this.targetUrlNormalizer.removeContextPathFromUriIfNeeded(targetUrl).toString();
        }
        return UriBuilder.fromUri((URI)targetUrl).replacePath("/servicedesk/customer").path(targetUrl.getPath()).build(new Object[0]).toString();
    }

    @Override
    protected boolean shouldAttemptAuthentication(HttpServletRequest req, HttpServletResponse resp, AuthenticationHandler authHandler) throws IOException, ServletException, URISyntaxException {
        return super.shouldAttemptAuthentication(req, resp, authHandler) && this.isIncludeCustomerLogins();
    }

    public boolean isIncludeCustomerLogins() {
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        return ssoConfig != null && ssoConfig.isIncludeCustomerLogins();
    }
}

