/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web;

import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.oidc.OidcAuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.saml.SamlAuthenticationHandler;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AuthenticationHandlerProvider {
    private final SamlAuthenticationHandler samlAuthenticationHandler;
    private final OidcAuthenticationHandler oidcAuthenticationHandler;

    @Inject
    public AuthenticationHandlerProvider(SamlAuthenticationHandler samlAuthenticationHandler, OidcAuthenticationHandler oidcAuthenticationHandler) {
        this.samlAuthenticationHandler = samlAuthenticationHandler;
        this.oidcAuthenticationHandler = oidcAuthenticationHandler;
    }

    @Nonnull
    public Optional<AuthenticationHandler> getAuthenticationHandler(@Nonnull SsoType ssoType) {
        switch (ssoType) {
            case SAML: {
                return Optional.of(this.samlAuthenticationHandler);
            }
            case OIDC: {
                return Optional.of(this.oidcAuthenticationHandler);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public AuthenticationHandler getAuthenticationHandlerUnchecked(@Nonnull SsoType ssoType) {
        return this.getAuthenticationHandler(ssoType).orElseThrow(() -> new IllegalArgumentException("Can't provide authentication handler for SSO type: " + (Object)((Object)ssoType)));
    }
}

