/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.util;

import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronExpressionValidator;
import com.atlassian.scheduler.cron.CronSyntaxException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class CronExpressionValidatorImpl
implements CronExpressionValidator {
    private final SchedulerService schedulerService;

    @Inject
    public CronExpressionValidatorImpl(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public boolean isValid(String cronExpression) {
        try {
            this.validate(cronExpression);
            return true;
        }
        catch (CronSyntaxException e) {
            return false;
        }
    }

    public void validate(String cronExpression) throws CronSyntaxException {
        try {
            this.schedulerService.calculateNextRunTime(Schedule.forCronExpression((String)cronExpression));
        }
        catch (CronSyntaxException e) {
            throw e;
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }
}

