/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.oidc;

import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.web.oidc.OidcDiscoveryException;
import com.google.common.base.Preconditions;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class OidcDiscoverySupport {
    private static final Logger log = LoggerFactory.getLogger(OidcDiscoverySupport.class);

    public OidcConfig refresh(OidcConfig config) throws OidcDiscoveryException {
        OIDCProviderMetadata metadata;
        Preconditions.checkArgument((boolean)config.isDiscoveryEnabled());
        try {
            metadata = this.fetch(config.getIssuerUrl());
        }
        catch (GeneralException | IOException e) {
            String strippedIssuer = StringUtils.stripEnd(config.getIssuerUrl(), "/");
            if (!strippedIssuer.equals(config.getIssuerUrl())) {
                return this.refresh(config.toBuilder().setIssuerUrl(strippedIssuer).build());
            }
            throw new OidcDiscoveryException(e);
        }
        OidcConfig oidcConfig = config.toBuilder().setAuthorizationEndpoint(metadata.getAuthorizationEndpointURI().toString()).setTokenEndpoint(metadata.getTokenEndpointURI().toString()).setUserInfoEndpoint(metadata.getUserInfoEndpointURI().toString()).build();
        log.debug("Fetched configuration from [{}] using discovery: {}", (Object)config.getIssuerUrl(), (Object)oidcConfig);
        return oidcConfig;
    }

    protected OIDCProviderMetadata fetch(String issuerUrl) throws IOException, GeneralException {
        return OIDCProviderMetadata.resolve(new Issuer(issuerUrl));
    }
}

