/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.util;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.StashComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import java.util.function.Predicate;
import javax.inject.Inject;

@JiraComponent
@BitbucketComponent
@StashComponent
@ConfluenceComponent
public class DefaultLicenseDataProvider
implements ProductLicenseDataProvider {
    public static final String DATA_CENTER_FAKE_PROPERTY_KEY = "com.atlassian.plugins.authentication.impl.web.LicenseFilter";
    public static final String DATA_CENTER_FAKE_PROPERTY_VALUE = "bypass";
    public static final String SD_LEGACY_ACTIVE_PROPERTY_KEY = "com.atlassian.servicedesk.active";
    public static final String SD_RBP_ACTIVE_PROPERTY_KEY = "jira.product.jira-servicedesk.active";
    private final Predicate<MultiProductLicenseDetails> dataCenterPredicate = license -> license.isDataCenter() || DATA_CENTER_FAKE_PROPERTY_VALUE.equals(license.getProperty(DATA_CENTER_FAKE_PROPERTY_KEY));
    private final Predicate<MultiProductLicenseDetails> serviceDeskPredicate = license -> Boolean.parseBoolean(license.getProperty(SD_LEGACY_ACTIVE_PROPERTY_KEY)) || Boolean.parseBoolean(license.getProperty(SD_RBP_ACTIVE_PROPERTY_KEY));
    private LicenseHandler licenseHandler;

    @Inject
    public DefaultLicenseDataProvider(@ComponentImport LicenseHandler licenseHandler) {
        this.licenseHandler = licenseHandler;
    }

    @Override
    public boolean isDataCenterProduct() {
        return this.licenseHandler.getAllProductLicenses().stream().allMatch(this.dataCenterPredicate);
    }

    @Override
    public boolean isServiceDeskProduct() {
        try {
            return this.licenseHandler.getAllProductLicenses().stream().anyMatch(this.serviceDeskPredicate);
        }
        catch (Exception e) {
            return false;
        }
    }
}

