/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.analytics.AbstractStatisticsCollectionService;
import com.atlassian.plugins.authentication.impl.analytics.events.AllowRedirectOverrideStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.ConfiguredAuthenticationMethodStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.IdpProviderStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.RedirectOnLoginStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.ServiceDeskCustomerLoginStatusEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ClusterWideStatisticsCollectionService
extends AbstractStatisticsCollectionService {
    private static final Logger log = LoggerFactory.getLogger(ClusterWideStatisticsCollectionService.class);
    private static final JobRunnerKey JOBRUNNER_KEY = JobRunnerKey.of((String)ClusterWideStatisticsCollectionService.class.getCanonicalName());
    private static final JobId JOB_ID = JobId.of((String)"analytics-collection");

    @Inject
    public ClusterWideStatisticsCollectionService(@ComponentImport EventPublisher eventPublisher, @ComponentImport SchedulerService schedulerService, @ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService, ProductLicenseDataProvider productLicenseDataProvider) {
        super(eventPublisher, schedulerService, applicationProperties, ssoConfigService, productLicenseDataProvider);
    }

    @Override
    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        String platformId = this.applicationProperties.getPlatformId();
        log.debug("Collecting configuration statistics");
        Stream.of(new ConfiguredAuthenticationMethodStatusEvent(ssoConfig, platformId), new AllowRedirectOverrideStatusEvent(ssoConfig, platformId), new IdpProviderStatusEvent(ssoConfig, platformId), new RedirectOnLoginStatusEvent(ssoConfig, platformId), new ServiceDeskCustomerLoginStatusEvent(ssoConfig, platformId, this.productLicenseDataProvider)).forEach(this::tryPublish);
        return JobRunnerResponse.success();
    }

    @Override
    protected RunMode getRunMode() {
        return RunMode.RUN_ONCE_PER_CLUSTER;
    }

    @Override
    protected JobId getJobId() {
        return JOB_ID;
    }

    @Override
    protected JobRunnerKey getJobRunnerKey() {
        return JOBRUNNER_KEY;
    }
}

