/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest;

import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.rest.model.SsoConfigEntity;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SsoConfigResourceService {
    private final SsoConfigService configService;
    private final ApplicationStateValidator applicationStateValidator;

    @Inject
    public SsoConfigResourceService(SsoConfigService configService, ApplicationStateValidator applicationStateValidator) {
        this.configService = configService;
        this.applicationStateValidator = applicationStateValidator;
    }

    @Nonnull
    public SsoConfigEntity getConfig() {
        return new SsoConfigEntity(this.configService.getSsoConfig());
    }

    public void disableSso() {
        this.configService.disableSso();
    }

    @Nonnull
    public SsoConfigEntity updateConfig(@Nonnull SsoConfigEntity entity) {
        if (entity.getSsoType() == SsoType.NONE) {
            this.configService.disableSso();
            return new SsoConfigEntity(null);
        }
        SsoConfig newConfig = this.buildConfig(entity);
        this.applicationStateValidator.checkSsoIsAllowed(newConfig);
        this.configService.updateSsoConfig(newConfig);
        return new SsoConfigEntity(this.configService.getSsoConfig());
    }

    private SsoConfig buildConfig(SsoConfigEntity entity) {
        SsoConfig currentConfig = this.configService.getSsoConfig();
        SsoType currentSsoType = currentConfig == null ? null : currentConfig.getSsoType();
        SsoType ssoType = entity.getSsoType() == null ? currentSsoType : entity.getSsoType();
        Preconditions.checkArgument((ssoType != null ? 1 : 0) != 0, (Object)"Field sso-type is required");
        switch (ssoType) {
            case SAML: {
                return this.buildSamlConfig(entity, SamlConfig.from(currentConfig));
            }
            case OIDC: {
                return this.buildOidcConfig(entity, OidcConfig.from(currentConfig));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown SSO type: %s", new Object[]{entity.getSsoType()}));
    }

    private SamlConfig buildSamlConfig(@Nonnull SsoConfigEntity entity, Optional<SamlConfig> currentConfig) {
        this.validateMutuallyExclusiveFields("crowd-url", entity.getCrowdUrl(), "sso-url", entity.getSsoUrl());
        this.validateMutuallyExclusiveFields("crowd-url", entity.getCrowdUrl(), "sso-issuer", entity.getSsoIssuer());
        SamlConfig.Builder builder = currentConfig.map(SamlConfig::toBuilder).orElseGet(SamlConfig::builder);
        this.updateGenericConfig(builder, entity);
        SamlConfig.IdpType idpType = this.calculateSamlIdpType(entity, currentConfig.orElse(null)).orElse(SamlConfig.IdpType.GENERIC);
        builder.setIdpType(idpType);
        if (idpType == SamlConfig.IdpType.CROWD) {
            this.setIfNonNull(entity.getCrowdUrl(), builder::setCrowdBaseUrl);
        } else {
            this.setIfNonNull(entity.getSsoUrl(), builder::setSsoUrl);
            this.setIfNonNull(entity.getSsoIssuer(), builder::setSsoIssuer);
        }
        this.setIfNonNull(entity.getCertificate(), builder::setCertificate);
        this.setIfNonNull(entity.getUserAttribute(), builder::setUsernameAttribute);
        return builder.build();
    }

    private OidcConfig buildOidcConfig(@Nonnull SsoConfigEntity entity, Optional<OidcConfig> currentConfig) {
        OidcConfig.Builder builder = currentConfig.map(OidcConfig::toBuilder).orElseGet(OidcConfig::builder);
        this.updateGenericConfig(builder, entity);
        this.setIfNonNull(entity.getIssuerUrl(), builder::setIssuerUrl);
        this.setIfNonNull(entity.getClientId(), builder::setClientId);
        this.setIfNonNull(entity.getClientSecret(), builder::setClientSecret);
        this.setIfNonNull(entity.getDiscoveryEnabled(), builder::setDiscoveryEnabled);
        this.setIfNonNull(entity.getDiscoveryRefreshCron(), builder::setDiscoveryRefreshCron);
        if (!Boolean.TRUE.equals(entity.getDiscoveryEnabled())) {
            this.setIfNonNull(entity.getAuthorizationEndpoint(), builder::setAuthorizationEndpoint);
            this.setIfNonNull(entity.getTokenEndpoint(), builder::setTokenEndpoint);
            this.setIfNonNull(entity.getUserInfoEndpoint(), builder::setUserInfoEndpoint);
        }
        this.setIfNonNull(entity.getAdditionalScopes(), scopes -> builder.setAdditionalScopes(Iterables.filter((Iterable)scopes, Objects::nonNull)));
        this.setIfNonNull(entity.getUsernameClaim(), builder::setUsernameClaim);
        return builder.build();
    }

    private void updateGenericConfig(@Nonnull SsoConfig.Builder<?> builder, @Nonnull SsoConfigEntity entity) {
        this.setIfNonNull(entity.getRedirectOnLogin(), builder::setRedirectOnLogin);
        this.setIfNonNull(entity.getIncludeCustomerLogins(), builder::setIncludeCustomerLogins);
        this.setIfNonNull(entity.getAllowRedirectOverride(), builder::setAllowRedirectOverride);
        this.setIfNonNull(entity.getEnableRememberMe(), builder::setEnableRememberMe);
    }

    @Nonnull
    private Optional<SamlConfig.IdpType> calculateSamlIdpType(@Nonnull SsoConfigEntity entity, @Nullable SamlConfig currentConfig) {
        SamlConfig.IdpType idpType = null;
        if (entity.getIdpType() != null) {
            idpType = entity.getIdpType();
        } else if (entity.getCrowdUrl() != null) {
            idpType = SamlConfig.IdpType.CROWD;
        } else if (entity.getSsoUrl() != null || entity.getSsoIssuer() != null) {
            idpType = SamlConfig.IdpType.GENERIC;
        } else if (currentConfig != null) {
            idpType = currentConfig.getIdpType();
        }
        return Optional.ofNullable(idpType);
    }

    private <T> void setIfNonNull(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }

    private void validateMutuallyExclusiveFields(@Nonnull String field1Name, @Nullable Object field1Value, @Nonnull String field2Name, @Nullable Object field2Value) {
        if (field1Value != null && field2Value != null) {
            throw new IllegalArgumentException(String.format("Either '%s' or '%s' must be set, received both", field1Name, field2Name));
        }
    }
}

