/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.event.SsoDisabledEvent;
import com.atlassian.plugins.authentication.event.SsoEnabledEvent;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

@BitbucketComponent
public class BitbucketAuditLogger {
    private final EventPublisher eventPublisher;

    @Inject
    public BitbucketAuditLogger(@ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSsoEnabledEvent(SsoEnabledEvent event) {
        this.eventPublisher.publish((Object)new BitbucketSsoEnabledEvent());
    }

    @EventListener
    public void onSsoDisabledEvent(SsoDisabledEvent event) {
        this.eventPublisher.publish((Object)new BitbucketSsoDisabledEvent());
    }

    private static interface BitbucketSsoEvent {
    }

    public static class SsoEventConverter
    implements AuditEntryConverter<BitbucketSsoEvent> {
        @Nonnull
        public AuditEntry convert(@Nonnull BitbucketSsoEvent event, @Nonnull AuditEntryBuilder auditEntryBuilder) {
            return auditEntryBuilder.action(event.getClass()).timestamp(new Date()).target(ScopeType.GLOBAL.name()).build();
        }
    }

    @Audited(converter=SsoEventConverter.class, priority=Priority.HIGH)
    public static class BitbucketSsoEnabledEvent
    implements BitbucketSsoEvent {
    }

    @Audited(converter=SsoEventConverter.class, priority=Priority.HIGH)
    public static class BitbucketSsoDisabledEvent
    implements BitbucketSsoEvent {
    }
}

