/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.plugins.authentication.impl.config.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigValidator;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.plugins.authentication.impl.util.ValidationUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.net.URL;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSsoConfigValidator<T extends SsoConfig>
implements SsoConfigValidator {
    protected static final Iterable<ErrorReason> ERROR_REQUIRED = Collections.singleton(ErrorReason.REQUIRED);
    protected static final Iterable<ErrorReason> ERROR_INCORRECT = Collections.singleton(ErrorReason.INCORRECT);
    protected static final Iterable<ErrorReason> ERROR_INSECURE = Collections.singleton(ErrorReason.INSECURE);
    protected static final Iterable<ErrorReason> NO_ERRORS = Collections.emptyList();
    protected final HttpsValidator httpsValidator;

    protected AbstractSsoConfigValidator(HttpsValidator httpsValidator) {
        this.httpsValidator = httpsValidator;
    }

    protected abstract SsoType getSsoType();

    protected abstract Class<T> getSsoClass();

    protected abstract void validate(@Nonnull ImmutableMultimap.Builder<String, ErrorReason> var1, @Nonnull T var2);

    @Override
    @Nonnull
    public final Multimap<String, ErrorReason> validate(@Nonnull SsoConfig ssoConfig) {
        Preconditions.checkArgument((ssoConfig.getSsoType() == this.getSsoType() ? 1 : 0) != 0, (Object)("Unsupported SSO type: " + (Object)((Object)ssoConfig.getSsoType())));
        Preconditions.checkArgument((boolean)this.getSsoClass().isInstance(ssoConfig), (Object)("Unsupported config type: " + ssoConfig.getClass()));
        ImmutableSetMultimap.Builder errors = ImmutableSetMultimap.builder();
        errors.putAll((Object)"sso-type", this.validateRequiredField((Object)ssoConfig.getSsoType()));
        this.validate((ImmutableMultimap.Builder<String, ErrorReason>)errors, (SsoConfig)this.getSsoClass().cast(ssoConfig));
        return errors.build();
    }

    protected Iterable<ErrorReason> validateRequiredField(Object value) {
        boolean empty = value instanceof String ? StringUtils.isEmpty((String)value) : value == null;
        return empty ? ERROR_REQUIRED : NO_ERRORS;
    }

    protected Iterable<ErrorReason> validateUrl(String ssoUrl) {
        if (!Strings.isNullOrEmpty((String)ssoUrl)) {
            if (!this.isValidUrl(ssoUrl)) {
                return ERROR_INCORRECT;
            }
            if (!this.isSecureUrl(ssoUrl)) {
                return ERROR_INSECURE;
            }
        }
        return NO_ERRORS;
    }

    private boolean isSecureUrl(String ssoUrl) {
        if (this.httpsValidator.isHttpsRequired() && !Strings.isNullOrEmpty((String)ssoUrl)) {
            URL url = ValidationUtils.convertToUrl(ssoUrl);
            return url == null || "https".equalsIgnoreCase(url.getProtocol());
        }
        return true;
    }

    private boolean isValidUrl(String urlString) {
        if (!Strings.isNullOrEmpty((String)urlString)) {
            try {
                ValidationUtils.convertToUrl(urlString);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

