/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.analytics.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.plugins.authentication.impl.analytics.events.AbstractStatusEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;

public class ConfiguredAuthenticationMethodStatusEvent
extends AbstractStatusEvent {
    public ConfiguredAuthenticationMethodStatusEvent(SsoConfig ssoConfig, String product) {
        super(ssoConfig, product);
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    @EventName
    public String getEventName() {
        String authMethod = "native";
        if (this.ssoConfig != null) {
            switch (this.ssoConfig.getSsoType()) {
                case SAML: {
                    authMethod = "saml";
                    break;
                }
                case OIDC: {
                    authMethod = "oidc";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SSO type: " + (Object)((Object)this.ssoConfig.getSsoType()));
                }
            }
        }
        return "plugins.authentication.status.authmethod." + authMethod;
    }
}

