/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.util;

import com.atlassian.plugins.authentication.impl.config.saml.InsecureUrlException;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.config.saml.SamlIdpType;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.impl.web.InvalidLicenseException;
import com.atlassian.plugins.authentication.impl.web.saml.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlResponse;
import com.google.common.collect.Iterables;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ApplicationStateValidator {
    private final HttpsValidator httpsValidator;
    private final SamlConfigService samlConfigService;
    private final ProductLicenseDataProvider productLicenseDataProvider;

    @Inject
    public ApplicationStateValidator(HttpsValidator httpsValidator, SamlConfigService samlConfigService, ProductLicenseDataProvider productLicenseDataProvider) {
        this.httpsValidator = httpsValidator;
        this.samlConfigService = samlConfigService;
        this.productLicenseDataProvider = productLicenseDataProvider;
    }

    public boolean canProcessAuthenticationRequest() {
        try {
            this.checkCanProcessAuthenticationRequest();
            return true;
        }
        catch (InsecureUrlException | InvalidLicenseException | AuthenticationHandlerNotConfiguredException e) {
            return false;
        }
    }

    public void checkCanProcessAuthenticationRequest() {
        SamlConfig config = this.samlConfigService.getSamlConfig();
        this.checkSamlConfigIsConfigured(config);
        this.validateConfig(config);
    }

    public void validateConfig(SamlConfig config) {
        if (config.getIdpType() == SamlIdpType.GENERIC) {
            this.checkIsDataCenterProduct();
        }
        this.checkBaseUrlIsHttps(config);
    }

    private void checkBaseUrlIsHttps(SamlConfig config) {
        if (!this.httpsValidator.isBaseUrlSecure(config)) {
            throw new InsecureUrlException("Base Url", "Base Url is not https");
        }
    }

    private void checkSamlConfigIsConfigured(SamlConfig config) {
        if (!config.isConfigured()) {
            throw new AuthenticationHandlerNotConfiguredException("Invalid SAML configuration");
        }
    }

    private void checkIsDataCenterProduct() {
        if (!this.productLicenseDataProvider.isDataCenterProduct()) {
            throw new InvalidLicenseException("Current license is not data center");
        }
    }

    public void checkHasAppropriateLicenseForSamlResponse(SamlResponse samlResponse) {
        if (this.isResponseNotFromCrowd(samlResponse)) {
            this.checkIsDataCenterProduct();
        }
    }

    private boolean isResponseNotFromCrowd(SamlResponse samlResponse) {
        return Optional.ofNullable(samlResponse.getAttribute("atl.crowd.properties.remember_me")).map(Iterables::isEmpty).orElse(true);
    }
}

