/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import com.atlassian.plugins.authentication.impl.config.saml.SamlIdpType;
import com.atlassian.plugins.authentication.impl.rest.saml.model.SamlConfigEntity;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class SamlConfig {
    private static String CROWD_SSO_URL_SUFFIX = "/console/secure/saml/sso.action";
    private static final SamlConfig EMPTY = new SamlConfig(null, null, null, null, false, false, false, null, null, SamlIdpType.NONE, false);
    private final String idpSsoUrl;
    private final String ssoIssuer;
    private final String usernameAttribute;
    private final String certificate;
    private final boolean redirectOnLogin;
    private final boolean includeCustomerLogins;
    private final boolean allowSamlRedirectOverride;
    private final String issuer;
    private final URL assertionConsumerUrl;
    private final boolean enableRememberMe;
    private final SamlIdpType idpType;

    public SamlConfig(String idpSsoUrl, String ssoIssuer, String usernameAttribute, String certificate, boolean redirectOnLogin, boolean includeCustomerLogins, boolean allowSamlRedirectOverride, boolean enableRememberMe) {
        this(idpSsoUrl, ssoIssuer, usernameAttribute, certificate, redirectOnLogin, includeCustomerLogins, allowSamlRedirectOverride, null, null, null, enableRememberMe);
    }

    public SamlConfig(String idpSsoUrl, String ssoIssuer, String usernameAttribute, String certificate, boolean redirectOnLogin, boolean includeCustomerLogins, boolean allowSamlRedirectOverride, String issuer, URL assertionConsumerUrl, SamlIdpType idpType, boolean enableRememberMe) {
        this.idpSsoUrl = idpSsoUrl;
        this.ssoIssuer = ssoIssuer;
        this.usernameAttribute = usernameAttribute;
        this.certificate = certificate;
        this.redirectOnLogin = redirectOnLogin;
        this.includeCustomerLogins = includeCustomerLogins;
        this.allowSamlRedirectOverride = allowSamlRedirectOverride;
        this.issuer = issuer;
        this.assertionConsumerUrl = assertionConsumerUrl;
        this.enableRememberMe = enableRememberMe;
        this.idpType = idpType != null ? idpType : SamlConfig.inferSamlIdpTypeFromUrl(idpSsoUrl);
    }

    public static SamlIdpType inferSamlIdpTypeFromUrl(String idpSsoUrl) {
        if (Strings.isNullOrEmpty((String)idpSsoUrl)) {
            return SamlIdpType.NONE;
        }
        if (idpSsoUrl.endsWith(CROWD_SSO_URL_SUFFIX)) {
            return SamlIdpType.CROWD;
        }
        return SamlIdpType.GENERIC;
    }

    public static SamlConfig emptyConfig() {
        return EMPTY;
    }

    public SamlIdpType getInferredIdpType() {
        return SamlConfig.inferSamlIdpTypeFromUrl(this.getIdpSsoUrl());
    }

    public SamlIdpType getIdpType() {
        return this.idpType;
    }

    public String getIdpSsoUrl() {
        return this.idpSsoUrl;
    }

    public String getSsoIssuer() {
        return this.ssoIssuer;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public boolean isAllowSamlRedirectOverride() {
        return this.allowSamlRedirectOverride;
    }

    public boolean isIncludeCustomerLogins() {
        return this.includeCustomerLogins;
    }

    public boolean isRedirectOnLogin() {
        return this.redirectOnLogin;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public URL getAssertionConsumerUrl() {
        return this.assertionConsumerUrl;
    }

    public boolean isConfigured() {
        return this.getIdpType() != SamlIdpType.NONE;
    }

    public boolean isEnableRememberMe() {
        return this.enableRememberMe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SamlConfig data) {
        return new Builder(data);
    }

    public Builder toBuilder() {
        return SamlConfig.builder(this);
    }

    public static final class Builder {
        private String idpSsoUrl;
        private String ssoIssuer;
        private String usernameAttribute;
        private String certificate;
        private boolean redirectOnLogin;
        private boolean includeCustomerLogins;
        private boolean allowSamlRedirectOverride;
        private String issuer;
        private URL assertionConsumerUrl;
        private boolean enableRememberMe;
        private SamlIdpType idpType;

        private Builder() {
        }

        private Builder(SamlConfig initialData) {
            this.idpSsoUrl = initialData.getIdpSsoUrl();
            this.ssoIssuer = initialData.getSsoIssuer();
            this.usernameAttribute = initialData.getUsernameAttribute();
            this.certificate = initialData.getCertificate();
            this.redirectOnLogin = initialData.isRedirectOnLogin();
            this.includeCustomerLogins = initialData.isIncludeCustomerLogins();
            this.allowSamlRedirectOverride = initialData.isAllowSamlRedirectOverride();
            this.issuer = initialData.getIssuer();
            this.assertionConsumerUrl = initialData.getAssertionConsumerUrl();
            this.enableRememberMe = initialData.isEnableRememberMe();
            this.idpType = initialData.getIdpType();
        }

        public Builder setIdpSsoUrl(String idpSsoUrl) {
            this.idpSsoUrl = idpSsoUrl;
            return this;
        }

        public Builder setSsoIssuer(String ssoIssuer) {
            this.ssoIssuer = ssoIssuer;
            return this;
        }

        public Builder setUsernameAttribute(String usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder setRedirectOnLogin(boolean redirectOnLogin) {
            this.redirectOnLogin = redirectOnLogin;
            return this;
        }

        public Builder setIncludeCustomerLogins(boolean includeCustomerLogins) {
            this.includeCustomerLogins = includeCustomerLogins;
            return this;
        }

        public Builder setAllowSamlRedirectOverride(boolean allowSamlRedirectOverride) {
            this.allowSamlRedirectOverride = allowSamlRedirectOverride;
            return this;
        }

        public Builder setIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder setAssertionConsumerUrl(URL assertionConsumerUrl) {
            this.assertionConsumerUrl = assertionConsumerUrl;
            return this;
        }

        public Builder setEnableRememberMe(boolean enableRememberMe) {
            this.enableRememberMe = enableRememberMe;
            return this;
        }

        public Builder setIdpType(SamlIdpType idpType) {
            this.idpType = idpType;
            return this;
        }

        public Builder setCrowdBaseUrl(String crowdBaseUrl) {
            crowdBaseUrl = StringUtils.removeEnd(crowdBaseUrl, CROWD_SSO_URL_SUFFIX);
            return this.setSsoIssuer(crowdBaseUrl).setIdpSsoUrl(StringUtils.stripEnd(crowdBaseUrl, "/") + CROWD_SSO_URL_SUFFIX);
        }

        public Builder updateNonNull(SamlConfigEntity newConfig) {
            SamlIdpType inferredType = null;
            if (newConfig.getSsoIssuer() != null) {
                this.setSsoIssuer(newConfig.getSsoIssuer());
                inferredType = SamlIdpType.GENERIC;
            }
            if (newConfig.getSsoUrl() != null) {
                this.setIdpSsoUrl(newConfig.getSsoUrl());
                inferredType = SamlIdpType.GENERIC;
            }
            if (newConfig.getCrowdUrl() != null) {
                if (inferredType != null) {
                    throw new IllegalArgumentException();
                }
                this.setCrowdBaseUrl(newConfig.getCrowdUrl());
                inferredType = SamlIdpType.CROWD;
            }
            Builder.updateIfNotNull(Optional.ofNullable(newConfig.getIdpType()).orElse(inferredType), this::setIdpType);
            Builder.updateIfNotNull(newConfig.getSigningCert(), this::setCertificate);
            Builder.updateIfNotNull(newConfig.getUserAttribute(), this::setUsernameAttribute);
            Builder.updateIfNotNull(newConfig.isAllowSamlRedirectOverride(), this::setAllowSamlRedirectOverride);
            Builder.updateIfNotNull(newConfig.isIncludeCustomerLogins(), this::setIncludeCustomerLogins);
            Builder.updateIfNotNull(newConfig.isRedirectOnLogin(), this::setRedirectOnLogin);
            Builder.updateIfNotNull(newConfig.isEnableRememberMe(), this::setEnableRememberMe);
            return this;
        }

        private static <V> void updateIfNotNull(V value, Consumer<? super V> consumer) {
            if (value != null) {
                consumer.accept(value);
            }
        }

        public SamlConfig build() {
            return new SamlConfig(this.idpSsoUrl, this.ssoIssuer, this.usernameAttribute, this.certificate, this.redirectOnLogin, this.includeCustomerLogins, this.allowSamlRedirectOverride, this.issuer, this.assertionConsumerUrl, this.idpType, this.enableRememberMe);
        }
    }
}

