/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.logout;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.web.filter.logout.LogoutFilter;
import com.atlassian.plugins.authentication.impl.web.saml.SessionDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraServiceDeskLogoutFilter
extends LogoutFilter {
    public static final String SD_LOGOUT_QUERY_PARAM = "sd-logout";
    static final String XHR_HEADER_VALUE = "XMLHttpRequest";
    static final String XHR_HEADER_NAME = "X-Requested-With";
    private final SessionDataService sessionDataService;

    @Inject
    public JiraServiceDeskLogoutFilter(SessionDataService sessionDataService, @ComponentImport ApplicationProperties applicationProperties, SamlConfigService samlConfigService) {
        super(applicationProperties, samlConfigService);
        this.sessionDataService = sessionDataService;
    }

    @Override
    protected boolean shouldRequestBeRedirected(HttpServletRequest request) {
        return this.samlConfigService.getSamlConfig().isIncludeCustomerLogins() && (this.sessionDataService.wasLoggedOutFromSdCustomerPortal(request) || Boolean.valueOf(request.getParameter("logout")) != false);
    }

    @Override
    protected void redirectToSamlLogoutPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.wasRequestedByAjax(request)) {
            this.sessionDataService.setLoggedOutFromSdCustomerPortal(request, false);
        }
        response.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/saml-logout" + "?" + SD_LOGOUT_QUERY_PARAM + "=" + true);
    }

    private boolean wasRequestedByAjax(HttpServletRequest request) {
        return XHR_HEADER_VALUE.equals(request.getHeader(XHR_HEADER_NAME));
    }
}

