/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ProductLicenseDataProvider {
    public static final String DATA_CENTER_FAKE_PROPERTY_KEY = "com.atlassian.plugins.authentication.impl.web.LicenseFilter";
    public static final String DATA_CENTER_FAKE_PROPERTY_VALUE = "bypass";
    public static final String SD_LEGACY_ACTIVE_PROPERTY_KEY = "com.atlassian.servicedesk.active";
    public static final String SD_RBP_ACTIVE_PROPERTY_KEY = "jira.product.jira-servicedesk.active";
    private final Predicate<MultiProductLicenseDetails> dataCenterPredicate = license -> {
        try {
            return license.isDataCenter() || DATA_CENTER_FAKE_PROPERTY_VALUE.equals(license.getProperty(DATA_CENTER_FAKE_PROPERTY_KEY));
        }
        catch (Exception refappWhyAreYouDoingThisToMe) {
            return false;
        }
    };
    private final Predicate<MultiProductLicenseDetails> serviceDeskPredicate = license -> {
        try {
            return Boolean.parseBoolean(license.getProperty(SD_LEGACY_ACTIVE_PROPERTY_KEY)) || Boolean.parseBoolean(license.getProperty(SD_RBP_ACTIVE_PROPERTY_KEY));
        }
        catch (Exception refappWhyAreYouDoingThisToMe) {
            return false;
        }
    };
    private LicenseHandler licenseHandler;

    @Inject
    public ProductLicenseDataProvider(@ComponentImport LicenseHandler licenseHandler) {
        this.licenseHandler = licenseHandler;
    }

    public boolean isDataCenterProduct() {
        try {
            return this.licenseHandler.getAllProductLicenses().stream().allMatch(this.dataCenterPredicate);
        }
        catch (Exception refappIHateYou) {
            return false;
        }
    }

    public boolean isServiceDeskProduct() {
        try {
            return this.licenseHandler.getAllProductLicenses().stream().anyMatch(this.serviceDeskPredicate);
        }
        catch (Exception IDontCareRefapp) {
            return false;
        }
    }
}

