/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.InsecureUrlException;
import com.atlassian.plugins.authentication.impl.rest.saml.model.ErrorEntity;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class InsecureUrlExceptionMapper
implements ExceptionMapper<InsecureUrlException> {
    private final I18nResolver i18nResolver;

    @Inject
    public InsecureUrlExceptionMapper(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(InsecureUrlException exception) {
        if (exception.getFieldName().equals("Single Sign On Url")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.config.save.fail.sso.url.insecure"))).build();
        }
        if (exception.getFieldName().equals("Base Url")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.config.save.fail.base.url.insecure"))).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorEntity(exception.getMessage())).build();
    }
}

