/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import java.net.URL;

public class SamlConfig {
    private final String idpSsoUrl;
    private final String ssoIssuer;
    private final String usernameAttribute;
    private final String certificate;
    private final Boolean redirectOnLogin;
    private final Boolean includeCustomerLogins;
    private final Boolean allowSamlRedirectOverride;
    private final String issuer;
    private final URL assertionConsumerUrl;
    private final Boolean enableRememberMe;

    public SamlConfig(String idpSsoUrl, String ssoIssuer, String usernameAttribute, String certificate, Boolean redirectOnLogin, Boolean includeCustomerLogins, Boolean allowSamlRedirectOverride, Boolean enableRememberMe) {
        this(idpSsoUrl, ssoIssuer, usernameAttribute, certificate, redirectOnLogin, includeCustomerLogins, allowSamlRedirectOverride, null, null, enableRememberMe);
    }

    public SamlConfig(String idpSsoUrl, String ssoIssuer, String usernameAttribute, String certificate, Boolean redirectOnLogin, Boolean includeCustomerLogins, Boolean allowSamlRedirectOverride, String issuer, URL assertionConsumerUrl, Boolean enableRememberMe) {
        this.idpSsoUrl = idpSsoUrl;
        this.ssoIssuer = ssoIssuer;
        this.usernameAttribute = usernameAttribute;
        this.certificate = certificate;
        this.redirectOnLogin = redirectOnLogin;
        this.includeCustomerLogins = includeCustomerLogins;
        this.allowSamlRedirectOverride = allowSamlRedirectOverride;
        this.issuer = issuer;
        this.assertionConsumerUrl = assertionConsumerUrl;
        this.enableRememberMe = enableRememberMe;
    }

    public String getIdpSsoUrl() {
        return this.idpSsoUrl;
    }

    public String getSsoIssuer() {
        return this.ssoIssuer;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public boolean isAllowSamlRedirectOverride() {
        return this.allowSamlRedirectOverride == null ? false : this.allowSamlRedirectOverride;
    }

    public boolean isIncludeCustomerLogins() {
        return this.includeCustomerLogins == null ? false : this.includeCustomerLogins;
    }

    public boolean isRedirectOnLogin() {
        return this.redirectOnLogin == null ? false : this.redirectOnLogin;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public URL getAssertionConsumerUrl() {
        return this.assertionConsumerUrl;
    }

    public boolean isConfigured() {
        return this.getCertificate() != null && this.getIdpSsoUrl() != null && this.getSsoIssuer() != null;
    }

    public boolean isEnableRememberMe() {
        return this.enableRememberMe == null ? false : this.enableRememberMe;
    }
}

