package com.atlassian.plugins.whitelist.ui;

import com.atlassian.plugins.whitelist.WhitelistType;
import com.google.common.base.Function;
import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class WhitelistTypeMapper
{
    private static final Map<String, WhitelistType> whitelistTypeMap = Maps.uniqueIndex(Arrays.asList(WhitelistType.values()), new Function<WhitelistType, String>()
    {
        @Override
        public String apply(final WhitelistType whitelistType)
        {
            return asString(whitelistType);
        }
    });

    public static String asString(final WhitelistType whitelistType)
    {
        checkNotNull(whitelistType, "whitelistType");
        return "whitelist." + whitelistType.name().toLowerCase().replace('_', '.');
    }

    public static WhitelistType asType(final String value)
    {
        checkNotNull(value, "value");
        final WhitelistType whitelistType = whitelistTypeMap.get(value);
        checkArgument(whitelistType != null, "Failed to find a matching whitelist type mapping for the given string '" + value + "'; known types are: " + whitelistTypeMap.keySet());
        return whitelistType;
    }
}
