package com.atlassian.plugins.whitelist;

import java.util.Optional;
import java.util.function.Function;

/**
 * @since 1.0
 */
public class ImmutableWhitelistRuleBuilder
{
    private Integer id;
    private String expression;
    private WhitelistType type;
    private boolean allowInbound;
    private boolean authenticationRequired;

    public static final Function<WhitelistRule, WhitelistRule> COPY =
            input -> Optional.ofNullable(input)
                    .map(i -> ImmutableWhitelistRule.builder().copyOf(i).build())
                    .orElse(null);

    public Integer getId() {
        return id;
    }

    public String getExpression() {
        return expression;
    }

    public WhitelistType getType() {
        return type;
    }

    public boolean isAllowInbound() {
        return allowInbound;
    }

    public boolean isAuthenticationRequired() {
        return authenticationRequired;
    }

    public ImmutableWhitelistRuleBuilder copyOf(final WhitelistRule template)
    {
        return id(template.getId())
                .expression(template.getExpression())
                .type(template.getType())
                .allowInbound(template.isAllowInbound())
                .authenticationRequired(template.isAuthenticationRequired());
    }

    public ImmutableWhitelistRuleBuilder id(final Integer id)
    {
        this.id = id;
        return this;
    }

    public ImmutableWhitelistRuleBuilder expression(final String expression)
    {
        this.expression = expression;
        return this;
    }

    public ImmutableWhitelistRuleBuilder type(final WhitelistType type)
    {
        this.type = type;
        return this;
    }

    public ImmutableWhitelistRuleBuilder allowInbound(final boolean allowInbound)
    {
        this.allowInbound = allowInbound;
        return this;
    }

    public ImmutableWhitelistRuleBuilder authenticationRequired(final boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
        return this;
    }

    public ImmutableWhitelistRule build()
    {
        return new ImmutableWhitelistRule(this);
    }
}
