package com.atlassian.plugins.whitelist;

/**
 * Enable or disable the whitelist in general. No permission check included.
 * @since 1.0
 */
public interface WhitelistOnOffSwitch
{
    /**
     * Enable the whitelist in general.
     */
    void enable();

    /**
     * Disable the whitelist in general.
     */
    void disable();

    /**
     * @return <code>true</code> if the whitelisting is enabled in general; <code>false</code> otherwise
     */
    boolean isEnabled();
}
